/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingProfileAgentAvailabilityTimerRequest extends ConnectRequest
        implements
        ToCopyableBuilder<UpdateRoutingProfileAgentAvailabilityTimerRequest.Builder, UpdateRoutingProfileAgentAvailabilityTimerRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> AGENT_AVAILABILITY_TIMER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentAvailabilityTimer")
            .getter(getter(UpdateRoutingProfileAgentAvailabilityTimerRequest::agentAvailabilityTimerAsString))
            .setter(setter(Builder::agentAvailabilityTimer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentAvailabilityTimer").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ROUTING_PROFILE_ID_FIELD, AGENT_AVAILABILITY_TIMER_FIELD));

    private final String instanceId;

    private final String routingProfileId;

    private final String agentAvailabilityTimer;

    private UpdateRoutingProfileAgentAvailabilityTimerRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>time since their
     * last inbound contact</i> or <i>longest idle time</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>time since
     *         their last inbound contact</i> or <i>longest idle time</i>.
     * @see AgentAvailabilityTimer
     */
    public final AgentAvailabilityTimer agentAvailabilityTimer() {
        return AgentAvailabilityTimer.fromValue(agentAvailabilityTimer);
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>time since their
     * last inbound contact</i> or <i>longest idle time</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>time since
     *         their last inbound contact</i> or <i>longest idle time</i>.
     * @see AgentAvailabilityTimer
     */
    public final String agentAvailabilityTimerAsString() {
        return agentAvailabilityTimer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAvailabilityTimerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileAgentAvailabilityTimerRequest)) {
            return false;
        }
        UpdateRoutingProfileAgentAvailabilityTimerRequest other = (UpdateRoutingProfileAgentAvailabilityTimerRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(agentAvailabilityTimerAsString(), other.agentAvailabilityTimerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoutingProfileAgentAvailabilityTimerRequest").add("InstanceId", instanceId())
                .add("RoutingProfileId", routingProfileId()).add("AgentAvailabilityTimer", agentAvailabilityTimerAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "AgentAvailabilityTimer":
            return Optional.ofNullable(clazz.cast(agentAvailabilityTimerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileAgentAvailabilityTimerRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileAgentAvailabilityTimerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRoutingProfileAgentAvailabilityTimerRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>time since
         * their last inbound contact</i> or <i>longest idle time</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>time
         *        since their last inbound contact</i> or <i>longest idle time</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(String agentAvailabilityTimer);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>time since
         * their last inbound contact</i> or <i>longest idle time</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>time
         *        since their last inbound contact</i> or <i>longest idle time</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String routingProfileId;

        private String agentAvailabilityTimer;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileAgentAvailabilityTimerRequest model) {
            super(model);
            instanceId(model.instanceId);
            routingProfileId(model.routingProfileId);
            agentAvailabilityTimer(model.agentAvailabilityTimer);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getAgentAvailabilityTimer() {
            return agentAvailabilityTimer;
        }

        public final void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
        }

        @Override
        public final Builder agentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        @Override
        public final Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
            this.agentAvailabilityTimer(agentAvailabilityTimer == null ? null : agentAvailabilityTimer.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileAgentAvailabilityTimerRequest build() {
            return new UpdateRoutingProfileAgentAvailabilityTimerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
