/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListViewVersionsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListViewVersionsResponse.Builder, ListViewVersionsResponse> {
    private static final SdkField<List<ViewVersionSummary>> VIEW_VERSION_SUMMARY_LIST_FIELD = SdkField
            .<List<ViewVersionSummary>> builder(MarshallingType.LIST)
            .memberName("ViewVersionSummaryList")
            .getter(getter(ListViewVersionsResponse::viewVersionSummaryList))
            .setter(setter(Builder::viewVersionSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewVersionSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViewVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViewVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListViewVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VIEW_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ViewVersionSummary> viewVersionSummaryList;

    private final String nextToken;

    private ListViewVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.viewVersionSummaryList = builder.viewVersionSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViewVersionSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasViewVersionSummaryList() {
        return viewVersionSummaryList != null && !(viewVersionSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of view version summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViewVersionSummaryList} method.
     * </p>
     * 
     * @return A list of view version summaries.
     */
    public final List<ViewVersionSummary> viewVersionSummaryList() {
        return viewVersionSummaryList;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasViewVersionSummaryList() ? viewVersionSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViewVersionsResponse)) {
            return false;
        }
        ListViewVersionsResponse other = (ListViewVersionsResponse) obj;
        return hasViewVersionSummaryList() == other.hasViewVersionSummaryList()
                && Objects.equals(viewVersionSummaryList(), other.viewVersionSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListViewVersionsResponse")
                .add("ViewVersionSummaryList", hasViewVersionSummaryList() ? viewVersionSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViewVersionSummaryList":
            return Optional.ofNullable(clazz.cast(viewVersionSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListViewVersionsResponse, T> g) {
        return obj -> g.apply((ListViewVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListViewVersionsResponse> {
        /**
         * <p>
         * A list of view version summaries.
         * </p>
         * 
         * @param viewVersionSummaryList
         *        A list of view version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewVersionSummaryList(Collection<ViewVersionSummary> viewVersionSummaryList);

        /**
         * <p>
         * A list of view version summaries.
         * </p>
         * 
         * @param viewVersionSummaryList
         *        A list of view version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewVersionSummaryList(ViewVersionSummary... viewVersionSummaryList);

        /**
         * <p>
         * A list of view version summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ViewVersionSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.ViewVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ViewVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #viewVersionSummaryList(List<ViewVersionSummary>)}.
         * 
         * @param viewVersionSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ViewVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewVersionSummaryList(java.util.Collection<ViewVersionSummary>)
         */
        Builder viewVersionSummaryList(Consumer<ViewVersionSummary.Builder>... viewVersionSummaryList);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<ViewVersionSummary> viewVersionSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListViewVersionsResponse model) {
            super(model);
            viewVersionSummaryList(model.viewVersionSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ViewVersionSummary.Builder> getViewVersionSummaryList() {
            List<ViewVersionSummary.Builder> result = ViewVersionSummaryListCopier.copyToBuilder(this.viewVersionSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViewVersionSummaryList(Collection<ViewVersionSummary.BuilderImpl> viewVersionSummaryList) {
            this.viewVersionSummaryList = ViewVersionSummaryListCopier.copyFromBuilder(viewVersionSummaryList);
        }

        @Override
        public final Builder viewVersionSummaryList(Collection<ViewVersionSummary> viewVersionSummaryList) {
            this.viewVersionSummaryList = ViewVersionSummaryListCopier.copy(viewVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewVersionSummaryList(ViewVersionSummary... viewVersionSummaryList) {
            viewVersionSummaryList(Arrays.asList(viewVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewVersionSummaryList(Consumer<ViewVersionSummary.Builder>... viewVersionSummaryList) {
            viewVersionSummaryList(Stream.of(viewVersionSummaryList)
                    .map(c -> ViewVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListViewVersionsResponse build() {
            return new ListViewVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
