/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a hierarchy group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyGroup implements SdkPojo, Serializable, ToCopyableBuilder<HierarchyGroup.Builder, HierarchyGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(HierarchyGroup::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(HierarchyGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HierarchyGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LEVEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LevelId").getter(getter(HierarchyGroup::levelId)).setter(setter(Builder::levelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelId").build()).build();

    private static final SdkField<HierarchyPath> HIERARCHY_PATH_FIELD = SdkField
            .<HierarchyPath> builder(MarshallingType.SDK_POJO).memberName("HierarchyPath")
            .getter(getter(HierarchyGroup::hierarchyPath)).setter(setter(Builder::hierarchyPath))
            .constructor(HierarchyPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyPath").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(HierarchyGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, LEVEL_ID_FIELD, HIERARCHY_PATH_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String levelId;

    private final HierarchyPath hierarchyPath;

    private final Map<String, String> tags;

    private HierarchyGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.levelId = builder.levelId;
        this.hierarchyPath = builder.hierarchyPath;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the hierarchy group.
     * </p>
     * 
     * @return The identifier of the hierarchy group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hierarchy group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hierarchy group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the hierarchy group.
     * </p>
     * 
     * @return The name of the hierarchy group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the level in the hierarchy group.
     * </p>
     * 
     * @return The identifier of the level in the hierarchy group.
     */
    public final String levelId() {
        return levelId;
    }

    /**
     * <p>
     * Information about the levels in the hierarchy group.
     * </p>
     * 
     * @return Information about the levels in the hierarchy group.
     */
    public final HierarchyPath hierarchyPath() {
        return hierarchyPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(levelId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyGroup)) {
            return false;
        }
        HierarchyGroup other = (HierarchyGroup) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(levelId(), other.levelId()) && Objects.equals(hierarchyPath(), other.hierarchyPath())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyGroup").add("Id", id()).add("Arn", arn()).add("Name", name()).add("LevelId", levelId())
                .add("HierarchyPath", hierarchyPath()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LevelId":
            return Optional.ofNullable(clazz.cast(levelId()));
        case "HierarchyPath":
            return Optional.ofNullable(clazz.cast(hierarchyPath()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchyGroup, T> g) {
        return obj -> g.apply((HierarchyGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyGroup> {
        /**
         * <p>
         * The identifier of the hierarchy group.
         * </p>
         * 
         * @param id
         *        The identifier of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hierarchy group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the hierarchy group.
         * </p>
         * 
         * @param name
         *        The name of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the level in the hierarchy group.
         * </p>
         * 
         * @param levelId
         *        The identifier of the level in the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelId(String levelId);

        /**
         * <p>
         * Information about the levels in the hierarchy group.
         * </p>
         * 
         * @param hierarchyPath
         *        Information about the levels in the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyPath(HierarchyPath hierarchyPath);

        /**
         * <p>
         * Information about the levels in the hierarchy group.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyPath.Builder} avoiding the need
         * to create one manually via {@link HierarchyPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyPath.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyPath(HierarchyPath)}.
         * 
         * @param hierarchyPath
         *        a consumer that will call methods on {@link HierarchyPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyPath(HierarchyPath)
         */
        default Builder hierarchyPath(Consumer<HierarchyPath.Builder> hierarchyPath) {
            return hierarchyPath(HierarchyPath.builder().applyMutation(hierarchyPath).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String levelId;

        private HierarchyPath hierarchyPath;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyGroup model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            levelId(model.levelId);
            hierarchyPath(model.hierarchyPath);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLevelId() {
            return levelId;
        }

        public final void setLevelId(String levelId) {
            this.levelId = levelId;
        }

        @Override
        public final Builder levelId(String levelId) {
            this.levelId = levelId;
            return this;
        }

        public final HierarchyPath.Builder getHierarchyPath() {
            return hierarchyPath != null ? hierarchyPath.toBuilder() : null;
        }

        public final void setHierarchyPath(HierarchyPath.BuilderImpl hierarchyPath) {
            this.hierarchyPath = hierarchyPath != null ? hierarchyPath.build() : null;
        }

        @Override
        public final Builder hierarchyPath(HierarchyPath hierarchyPath) {
            this.hierarchyPath = hierarchyPath;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public HierarchyGroup build() {
            return new HierarchyGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
