/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaskTemplateRequest extends ConnectRequest implements
        ToCopyableBuilder<GetTaskTemplateRequest.Builder, GetTaskTemplateRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetTaskTemplateRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> TASK_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskTemplateId").getter(getter(GetTaskTemplateRequest::taskTemplateId))
            .setter(setter(Builder::taskTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TaskTemplateId").build()).build();

    private static final SdkField<String> SNAPSHOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotVersion").getter(getter(GetTaskTemplateRequest::snapshotVersion))
            .setter(setter(Builder::snapshotVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("snapshotVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            TASK_TEMPLATE_ID_FIELD, SNAPSHOT_VERSION_FIELD));

    private final String instanceId;

    private final String taskTemplateId;

    private final String snapshotVersion;

    private GetTaskTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.taskTemplateId = builder.taskTemplateId;
        this.snapshotVersion = builder.snapshotVersion;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique identifier for the task template.
     * </p>
     * 
     * @return A unique identifier for the task template.
     */
    public final String taskTemplateId() {
        return taskTemplateId;
    }

    /**
     * <p>
     * The system generated version of a task template that is associated with a task, when the task is created.
     * </p>
     * 
     * @return The system generated version of a task template that is associated with a task, when the task is created.
     */
    public final String snapshotVersion() {
        return snapshotVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(taskTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaskTemplateRequest)) {
            return false;
        }
        GetTaskTemplateRequest other = (GetTaskTemplateRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(taskTemplateId(), other.taskTemplateId())
                && Objects.equals(snapshotVersion(), other.snapshotVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaskTemplateRequest").add("InstanceId", instanceId()).add("TaskTemplateId", taskTemplateId())
                .add("SnapshotVersion", snapshotVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "TaskTemplateId":
            return Optional.ofNullable(clazz.cast(taskTemplateId()));
        case "SnapshotVersion":
            return Optional.ofNullable(clazz.cast(snapshotVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTaskTemplateRequest, T> g) {
        return obj -> g.apply((GetTaskTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTaskTemplateRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique identifier for the task template.
         * </p>
         * 
         * @param taskTemplateId
         *        A unique identifier for the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTemplateId(String taskTemplateId);

        /**
         * <p>
         * The system generated version of a task template that is associated with a task, when the task is created.
         * </p>
         * 
         * @param snapshotVersion
         *        The system generated version of a task template that is associated with a task, when the task is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotVersion(String snapshotVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String taskTemplateId;

        private String snapshotVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaskTemplateRequest model) {
            super(model);
            instanceId(model.instanceId);
            taskTemplateId(model.taskTemplateId);
            snapshotVersion(model.snapshotVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTaskTemplateId() {
            return taskTemplateId;
        }

        public final void setTaskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
        }

        @Override
        public final Builder taskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
            return this;
        }

        public final String getSnapshotVersion() {
            return snapshotVersion;
        }

        public final void setSnapshotVersion(String snapshotVersion) {
            this.snapshotVersion = snapshotVersion;
        }

        @Override
        public final Builder snapshotVersion(String snapshotVersion) {
            this.snapshotVersion = snapshotVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTaskTemplateRequest build() {
            return new GetTaskTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
