/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the automation configuration in single select questions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSingleSelectQuestionOption implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormSingleSelectQuestionOption.Builder, EvaluationFormSingleSelectQuestionOption> {
    private static final SdkField<String> REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RefId")
            .getter(getter(EvaluationFormSingleSelectQuestionOption::refId)).setter(setter(Builder::refId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(EvaluationFormSingleSelectQuestionOption::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<Integer> SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Score")
            .getter(getter(EvaluationFormSingleSelectQuestionOption::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFail").getter(getter(EvaluationFormSingleSelectQuestionOption::automaticFail))
            .setter(setter(Builder::automaticFail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REF_ID_FIELD, TEXT_FIELD,
            SCORE_FIELD, AUTOMATIC_FAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String refId;

    private final String text;

    private final Integer score;

    private final Boolean automaticFail;

    private EvaluationFormSingleSelectQuestionOption(BuilderImpl builder) {
        this.refId = builder.refId;
        this.text = builder.text;
        this.score = builder.score;
        this.automaticFail = builder.automaticFail;
    }

    /**
     * <p>
     * The identifier of the answer option. An identifier must be unique within the question.
     * </p>
     * 
     * @return The identifier of the answer option. An identifier must be unique within the question.
     */
    public final String refId() {
        return refId;
    }

    /**
     * <p>
     * The title of the answer option.
     * </p>
     * 
     * @return The title of the answer option.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The score assigned to the answer option.
     * </p>
     * 
     * @return The score assigned to the answer option.
     */
    public final Integer score() {
        return score;
    }

    /**
     * <p>
     * The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation
     * gets a score of 0.
     * </p>
     * 
     * @return The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
     *         evaluation gets a score of 0.
     */
    public final Boolean automaticFail() {
        return automaticFail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(refId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSingleSelectQuestionOption)) {
            return false;
        }
        EvaluationFormSingleSelectQuestionOption other = (EvaluationFormSingleSelectQuestionOption) obj;
        return Objects.equals(refId(), other.refId()) && Objects.equals(text(), other.text())
                && Objects.equals(score(), other.score()) && Objects.equals(automaticFail(), other.automaticFail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSingleSelectQuestionOption").add("RefId", refId()).add("Text", text())
                .add("Score", score()).add("AutomaticFail", automaticFail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefId":
            return Optional.ofNullable(clazz.cast(refId()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "AutomaticFail":
            return Optional.ofNullable(clazz.cast(automaticFail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSingleSelectQuestionOption, T> g) {
        return obj -> g.apply((EvaluationFormSingleSelectQuestionOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSingleSelectQuestionOption> {
        /**
         * <p>
         * The identifier of the answer option. An identifier must be unique within the question.
         * </p>
         * 
         * @param refId
         *        The identifier of the answer option. An identifier must be unique within the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refId(String refId);

        /**
         * <p>
         * The title of the answer option.
         * </p>
         * 
         * @param text
         *        The title of the answer option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The score assigned to the answer option.
         * </p>
         * 
         * @param score
         *        The score assigned to the answer option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Integer score);

        /**
         * <p>
         * The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
         * evaluation gets a score of 0.
         * </p>
         * 
         * @param automaticFail
         *        The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
         *        evaluation gets a score of 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFail(Boolean automaticFail);
    }

    static final class BuilderImpl implements Builder {
        private String refId;

        private String text;

        private Integer score;

        private Boolean automaticFail;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSingleSelectQuestionOption model) {
            refId(model.refId);
            text(model.text);
            score(model.score);
            automaticFail(model.automaticFail);
        }

        public final String getRefId() {
            return refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Integer getScore() {
            return score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        public final Boolean getAutomaticFail() {
            return automaticFail;
        }

        public final void setAutomaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
        }

        @Override
        public final Builder automaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
            return this;
        }

        @Override
        public EvaluationFormSingleSelectQuestionOption build() {
            return new EvaluationFormSingleSelectQuestionOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
