/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityProfileResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeSecurityProfileResponse.Builder, DescribeSecurityProfileResponse> {
    private static final SdkField<SecurityProfile> SECURITY_PROFILE_FIELD = SdkField
            .<SecurityProfile> builder(MarshallingType.SDK_POJO).memberName("SecurityProfile")
            .getter(getter(DescribeSecurityProfileResponse::securityProfile)).setter(setter(Builder::securityProfile))
            .constructor(SecurityProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_FIELD));

    private final SecurityProfile securityProfile;

    private DescribeSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfile = builder.securityProfile;
    }

    /**
     * <p>
     * The security profile.
     * </p>
     * 
     * @return The security profile.
     */
    public final SecurityProfile securityProfile() {
        return securityProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityProfileResponse)) {
            return false;
        }
        DescribeSecurityProfileResponse other = (DescribeSecurityProfileResponse) obj;
        return Objects.equals(securityProfile(), other.securityProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityProfileResponse").add("SecurityProfile", securityProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityProfile":
            return Optional.ofNullable(clazz.cast(securityProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityProfileResponse, T> g) {
        return obj -> g.apply((DescribeSecurityProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecurityProfileResponse> {
        /**
         * <p>
         * The security profile.
         * </p>
         * 
         * @param securityProfile
         *        The security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfile(SecurityProfile securityProfile);

        /**
         * <p>
         * The security profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityProfile.Builder} avoiding the
         * need to create one manually via {@link SecurityProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #securityProfile(SecurityProfile)}.
         * 
         * @param securityProfile
         *        a consumer that will call methods on {@link SecurityProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfile(SecurityProfile)
         */
        default Builder securityProfile(Consumer<SecurityProfile.Builder> securityProfile) {
            return securityProfile(SecurityProfile.builder().applyMutation(securityProfile).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private SecurityProfile securityProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityProfileResponse model) {
            super(model);
            securityProfile(model.securityProfile);
        }

        public final SecurityProfile.Builder getSecurityProfile() {
            return securityProfile != null ? securityProfile.toBuilder() : null;
        }

        public final void setSecurityProfile(SecurityProfile.BuilderImpl securityProfile) {
            this.securityProfile = securityProfile != null ? securityProfile.build() : null;
        }

        @Override
        public final Builder securityProfile(SecurityProfile securityProfile) {
            this.securityProfile = securityProfile;
            return this;
        }

        @Override
        public DescribeSecurityProfileResponse build() {
            return new DescribeSecurityProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
