/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePromptResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribePromptResponse.Builder, DescribePromptResponse> {
    private static final SdkField<Prompt> PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO).memberName("Prompt")
            .getter(getter(DescribePromptResponse::prompt)).setter(setter(Builder::prompt)).constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_FIELD));

    private final Prompt prompt;

    private DescribePromptResponse(BuilderImpl builder) {
        super(builder);
        this.prompt = builder.prompt;
    }

    /**
     * <p>
     * Information about the prompt.
     * </p>
     * 
     * @return Information about the prompt.
     */
    public final Prompt prompt() {
        return prompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePromptResponse)) {
            return false;
        }
        DescribePromptResponse other = (DescribePromptResponse) obj;
        return Objects.equals(prompt(), other.prompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePromptResponse").add("Prompt", prompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePromptResponse, T> g) {
        return obj -> g.apply((DescribePromptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePromptResponse> {
        /**
         * <p>
         * Information about the prompt.
         * </p>
         * 
         * @param prompt
         *        Information about the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(Prompt prompt);

        /**
         * <p>
         * Information about the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link Prompt.Builder} avoiding the need to
         * create one manually via {@link Prompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #prompt(Prompt)}.
         * 
         * @param prompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prompt(Prompt)
         */
        default Builder prompt(Consumer<Prompt.Builder> prompt) {
            return prompt(Prompt.builder().applyMutation(prompt).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Prompt prompt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePromptResponse model) {
            super(model);
            prompt(model.prompt);
        }

        public final Prompt.Builder getPrompt() {
            return prompt != null ? prompt.toBuilder() : null;
        }

        public final void setPrompt(Prompt.BuilderImpl prompt) {
            this.prompt = prompt != null ? prompt.build() : null;
        }

        @Override
        public final Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public DescribePromptResponse build() {
            return new DescribePromptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
