/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The current metric names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum CurrentMetricName {
    AGENTS_ONLINE("AGENTS_ONLINE"),

    AGENTS_AVAILABLE("AGENTS_AVAILABLE"),

    AGENTS_ON_CALL("AGENTS_ON_CALL"),

    AGENTS_NON_PRODUCTIVE("AGENTS_NON_PRODUCTIVE"),

    AGENTS_AFTER_CONTACT_WORK("AGENTS_AFTER_CONTACT_WORK"),

    AGENTS_ERROR("AGENTS_ERROR"),

    AGENTS_STAFFED("AGENTS_STAFFED"),

    CONTACTS_IN_QUEUE("CONTACTS_IN_QUEUE"),

    OLDEST_CONTACT_AGE("OLDEST_CONTACT_AGE"),

    CONTACTS_SCHEDULED("CONTACTS_SCHEDULED"),

    AGENTS_ON_CONTACT("AGENTS_ON_CONTACT"),

    SLOTS_ACTIVE("SLOTS_ACTIVE"),

    SLOTS_AVAILABLE("SLOTS_AVAILABLE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CurrentMetricName> VALUE_MAP = EnumUtils.uniqueIndex(CurrentMetricName.class,
            CurrentMetricName::toString);

    private final String value;

    private CurrentMetricName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CurrentMetricName corresponding to the value
     */
    public static CurrentMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CurrentMetricName}s
     */
    public static Set<CurrentMetricName> knownValues() {
        Set<CurrentMetricName> knownValues = EnumSet.allOf(CurrentMetricName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
