/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRemediationExecutionRequest extends ConfigRequest implements
        ToCopyableBuilder<StartRemediationExecutionRequest.Builder, StartRemediationExecutionRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(StartRemediationExecutionRequest::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<List<ResourceKey>> RESOURCE_KEYS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .memberName("ResourceKeys")
            .getter(getter(StartRemediationExecutionRequest::resourceKeys))
            .setter(setter(Builder::resourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_KEYS_FIELD));

    private final String configRuleName;

    private final List<ResourceKey> resourceKeys;

    private StartRemediationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.resourceKeys = builder.resourceKeys;
    }

    /**
     * <p>
     * The list of names of Config rules that you want to run remediation execution for.
     * </p>
     * 
     * @return The list of names of Config rules that you want to run remediation execution for.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceKeys() {
        return resourceKeys != null && !(resourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource keys to be processed with the current request. Each element in the list consists of the
     * resource type and resource ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceKeys} method.
     * </p>
     * 
     * @return A list of resource keys to be processed with the current request. Each element in the list consists of
     *         the resource type and resource ID.
     */
    public final List<ResourceKey> resourceKeys() {
        return resourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceKeys() ? resourceKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemediationExecutionRequest)) {
            return false;
        }
        StartRemediationExecutionRequest other = (StartRemediationExecutionRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && hasResourceKeys() == other.hasResourceKeys()
                && Objects.equals(resourceKeys(), other.resourceKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRemediationExecutionRequest").add("ConfigRuleName", configRuleName())
                .add("ResourceKeys", hasResourceKeys() ? resourceKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceKeys":
            return Optional.ofNullable(clazz.cast(resourceKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRemediationExecutionRequest, T> g) {
        return obj -> g.apply((StartRemediationExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRemediationExecutionRequest> {
        /**
         * <p>
         * The list of names of Config rules that you want to run remediation execution for.
         * </p>
         * 
         * @param configRuleName
         *        The list of names of Config rules that you want to run remediation execution for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(Collection<ResourceKey> resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * 
         * @param resourceKeys
         *        A list of resource keys to be processed with the current request. Each element in the list consists of
         *        the resource type and resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKeys(ResourceKey... resourceKeys);

        /**
         * <p>
         * A list of resource keys to be processed with the current request. Each element in the list consists of the
         * resource type and resource ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.config.model.ResourceKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceKeys(List<ResourceKey>)}.
         * 
         * @param resourceKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceKeys(java.util.Collection<ResourceKey>)
         */
        Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private List<ResourceKey> resourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemediationExecutionRequest model) {
            super(model);
            configRuleName(model.configRuleName);
            resourceKeys(model.resourceKeys);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final List<ResourceKey.Builder> getResourceKeys() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.resourceKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceKeys(Collection<ResourceKey.BuilderImpl> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copyFromBuilder(resourceKeys);
        }

        @Override
        public final Builder resourceKeys(Collection<ResourceKey> resourceKeys) {
            this.resourceKeys = ResourceKeysCopier.copy(resourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(ResourceKey... resourceKeys) {
            resourceKeys(Arrays.asList(resourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceKeys(Consumer<ResourceKey.Builder>... resourceKeys) {
            resourceKeys(Stream.of(resourceKeys).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRemediationExecutionRequest build() {
            return new StartRemediationExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
