/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStoredQueryRequest extends ConfigRequest implements
        ToCopyableBuilder<PutStoredQueryRequest.Builder, PutStoredQueryRequest> {
    private static final SdkField<StoredQuery> STORED_QUERY_FIELD = SdkField.<StoredQuery> builder(MarshallingType.SDK_POJO)
            .memberName("StoredQuery").getter(getter(PutStoredQueryRequest::storedQuery)).setter(setter(Builder::storedQuery))
            .constructor(StoredQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredQuery").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutStoredQueryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STORED_QUERY_FIELD, TAGS_FIELD));

    private final StoredQuery storedQuery;

    private final List<Tag> tags;

    private PutStoredQueryRequest(BuilderImpl builder) {
        super(builder);
        this.storedQuery = builder.storedQuery;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and
     * <code>Expression</code>.
     * </p>
     * <note>
     * <p>
     * When you are creating a query, you must provide a query name and an expression. When you are updating a query,
     * you must provide a query name but updating the description is optional.
     * </p>
     * </note>
     * 
     * @return A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and
     *         <code>Expression</code>.</p> <note>
     *         <p>
     *         When you are creating a query, you must provide a query name and an expression. When you are updating a
     *         query, you must provide a query name but updating the description is optional.
     *         </p>
     */
    public final StoredQuery storedQuery() {
        return storedQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Tags</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <code>Tags</code> object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storedQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStoredQueryRequest)) {
            return false;
        }
        PutStoredQueryRequest other = (PutStoredQueryRequest) obj;
        return Objects.equals(storedQuery(), other.storedQuery()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStoredQueryRequest").add("StoredQuery", storedQuery()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoredQuery":
            return Optional.ofNullable(clazz.cast(storedQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStoredQueryRequest, T> g) {
        return obj -> g.apply((PutStoredQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutStoredQueryRequest> {
        /**
         * <p>
         * A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and
         * <code>Expression</code>.
         * </p>
         * <note>
         * <p>
         * When you are creating a query, you must provide a query name and an expression. When you are updating a
         * query, you must provide a query name but updating the description is optional.
         * </p>
         * </note>
         * 
         * @param storedQuery
         *        A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and
         *        <code>Expression</code>.</p> <note>
         *        <p>
         *        When you are creating a query, you must provide a query name and an expression. When you are updating
         *        a query, you must provide a query name but updating the description is optional.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedQuery(StoredQuery storedQuery);

        /**
         * <p>
         * A list of <code>StoredQuery</code> objects. The mandatory fields are <code>QueryName</code> and
         * <code>Expression</code>.
         * </p>
         * <note>
         * <p>
         * When you are creating a query, you must provide a query name and an expression. When you are updating a
         * query, you must provide a query name but updating the description is optional.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StoredQuery.Builder} avoiding the
         * need to create one manually via {@link StoredQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoredQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #storedQuery(StoredQuery)}.
         * 
         * @param storedQuery
         *        a consumer that will call methods on {@link StoredQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storedQuery(StoredQuery)
         */
        default Builder storedQuery(Consumer<StoredQuery.Builder> storedQuery) {
            return storedQuery(StoredQuery.builder().applyMutation(storedQuery).build());
        }

        /**
         * <p>
         * A list of <code>Tags</code> object.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tags</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <code>Tags</code> object.
         * </p>
         * 
         * @param tags
         *        A list of <code>Tags</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <code>Tags</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.config.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.config.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.config.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private StoredQuery storedQuery;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutStoredQueryRequest model) {
            super(model);
            storedQuery(model.storedQuery);
            tags(model.tags);
        }

        public final StoredQuery.Builder getStoredQuery() {
            return storedQuery != null ? storedQuery.toBuilder() : null;
        }

        public final void setStoredQuery(StoredQuery.BuilderImpl storedQuery) {
            this.storedQuery = storedQuery != null ? storedQuery.build() : null;
        }

        @Override
        public final Builder storedQuery(StoredQuery storedQuery) {
            this.storedQuery = storedQuery;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStoredQueryRequest build() {
            return new PutStoredQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
