/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the job data for a partner action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartyJobData implements SdkPojo, Serializable,
        ToCopyableBuilder<ThirdPartyJobData.Builder, ThirdPartyJobData> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .memberName("actionTypeId").getter(getter(ThirdPartyJobData::actionTypeId)).setter(setter(Builder::actionTypeId))
            .constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()).build();

    private static final SdkField<ActionConfiguration> ACTION_CONFIGURATION_FIELD = SdkField
            .<ActionConfiguration> builder(MarshallingType.SDK_POJO).memberName("actionConfiguration")
            .getter(getter(ThirdPartyJobData::actionConfiguration)).setter(setter(Builder::actionConfiguration))
            .constructor(ActionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfiguration").build())
            .build();

    private static final SdkField<PipelineContext> PIPELINE_CONTEXT_FIELD = SdkField
            .<PipelineContext> builder(MarshallingType.SDK_POJO).memberName("pipelineContext")
            .getter(getter(ThirdPartyJobData::pipelineContext)).setter(setter(Builder::pipelineContext))
            .constructor(PipelineContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineContext").build()).build();

    private static final SdkField<List<Artifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<List<Artifact>> builder(MarshallingType.LIST)
            .memberName("inputArtifacts")
            .getter(getter(ThirdPartyJobData::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Artifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Artifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Artifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<List<Artifact>> builder(MarshallingType.LIST)
            .memberName("outputArtifacts")
            .getter(getter(ThirdPartyJobData::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Artifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Artifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AWSSessionCredentials> ARTIFACT_CREDENTIALS_FIELD = SdkField
            .<AWSSessionCredentials> builder(MarshallingType.SDK_POJO).memberName("artifactCredentials")
            .getter(getter(ThirdPartyJobData::artifactCredentials)).setter(setter(Builder::artifactCredentials))
            .constructor(AWSSessionCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactCredentials").build())
            .build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(ThirdPartyJobData::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField
            .<EncryptionKey> builder(MarshallingType.SDK_POJO).memberName("encryptionKey")
            .getter(getter(ThirdPartyJobData::encryptionKey)).setter(setter(Builder::encryptionKey))
            .constructor(EncryptionKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD,
            ACTION_CONFIGURATION_FIELD, PIPELINE_CONTEXT_FIELD, INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD,
            ARTIFACT_CREDENTIALS_FIELD, CONTINUATION_TOKEN_FIELD, ENCRYPTION_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionTypeId actionTypeId;

    private final ActionConfiguration actionConfiguration;

    private final PipelineContext pipelineContext;

    private final List<Artifact> inputArtifacts;

    private final List<Artifact> outputArtifacts;

    private final AWSSessionCredentials artifactCredentials;

    private final String continuationToken;

    private final EncryptionKey encryptionKey;

    private ThirdPartyJobData(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.actionConfiguration = builder.actionConfiguration;
        this.pipelineContext = builder.pipelineContext;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.artifactCredentials = builder.artifactCredentials;
        this.continuationToken = builder.continuationToken;
        this.encryptionKey = builder.encryptionKey;
    }

    /**
     * <p>
     * Represents information about an action type.
     * </p>
     * 
     * @return Represents information about an action type.
     */
    public final ActionTypeId actionTypeId() {
        return actionTypeId;
    }

    /**
     * <p>
     * Represents information about an action configuration.
     * </p>
     * 
     * @return Represents information about an action configuration.
     */
    public final ActionConfiguration actionConfiguration() {
        return actionConfiguration;
    }

    /**
     * <p>
     * Represents information about a pipeline to a job worker.
     * </p>
     * <note>
     * <p>
     * Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.
     * </p>
     * </note>
     * 
     * @return Represents information about a pipeline to a job worker.</p> <note>
     *         <p>
     *         Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.
     *         </p>
     */
    public final PipelineContext pipelineContext() {
        return pipelineContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as
     * "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the
     * name of an output artifact generated by an action in an earlier action or stage of the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifacts} method.
     * </p>
     * 
     * @return The name of the artifact that is worked on by the action, if any. This name might be system-generated,
     *         such as "MyApp", or it might be defined by the user when the action is created. The input artifact name
     *         must match the name of an output artifact generated by an action in an earlier action or stage of the
     *         pipeline.
     */
    public final List<Artifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the artifact that is the result of the action, if any. This name might be system-generated, such as
     * "MyBuiltApp", or it might be defined by the user when the action is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifacts} method.
     * </p>
     * 
     * @return The name of the artifact that is the result of the action, if any. This name might be system-generated,
     *         such as "MyBuiltApp", or it might be defined by the user when the action is created.
     */
    public final List<Artifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * <p>
     * Represents an Amazon Web Services session credentials object. These credentials are temporary credentials that
     * are issued by Amazon Web Services Secure Token Service (STS). They can be used to access input and output
     * artifacts in the S3 bucket used to store artifact for the pipeline in CodePipeline.
     * </p>
     * 
     * @return Represents an Amazon Web Services session credentials object. These credentials are temporary credentials
     *         that are issued by Amazon Web Services Secure Token Service (STS). They can be used to access input and
     *         output artifacts in the S3 bucket used to store artifact for the pipeline in CodePipeline.
     */
    public final AWSSessionCredentials artifactCredentials() {
        return artifactCredentials;
    }

    /**
     * <p>
     * A system-generated token, such as a CodeDeploy deployment ID, that a job requires to continue the job
     * asynchronously.
     * </p>
     * 
     * @return A system-generated token, such as a CodeDeploy deployment ID, that a job requires to continue the job
     *         asynchronously.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an Amazon Web
     * Services Key Management Service (Amazon Web Services KMS) key. This is optional and might not be present.
     * </p>
     * 
     * @return The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an
     *         Amazon Web Services Key Management Service (Amazon Web Services KMS) key. This is optional and might not
     *         be present.
     */
    public final EncryptionKey encryptionKey() {
        return encryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(actionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineContext());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifactCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyJobData)) {
            return false;
        }
        ThirdPartyJobData other = (ThirdPartyJobData) obj;
        return Objects.equals(actionTypeId(), other.actionTypeId())
                && Objects.equals(actionConfiguration(), other.actionConfiguration())
                && Objects.equals(pipelineContext(), other.pipelineContext()) && hasInputArtifacts() == other.hasInputArtifacts()
                && Objects.equals(inputArtifacts(), other.inputArtifacts()) && hasOutputArtifacts() == other.hasOutputArtifacts()
                && Objects.equals(outputArtifacts(), other.outputArtifacts())
                && Objects.equals(artifactCredentials(), other.artifactCredentials())
                && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(encryptionKey(), other.encryptionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThirdPartyJobData").add("ActionTypeId", actionTypeId())
                .add("ActionConfiguration", actionConfiguration()).add("PipelineContext", pipelineContext())
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null)
                .add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("ArtifactCredentials", artifactCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContinuationToken", continuationToken()).add("EncryptionKey", encryptionKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypeId":
            return Optional.ofNullable(clazz.cast(actionTypeId()));
        case "actionConfiguration":
            return Optional.ofNullable(clazz.cast(actionConfiguration()));
        case "pipelineContext":
            return Optional.ofNullable(clazz.cast(pipelineContext()));
        case "inputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "outputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "artifactCredentials":
            return Optional.ofNullable(clazz.cast(artifactCredentials()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartyJobData, T> g) {
        return obj -> g.apply((ThirdPartyJobData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartyJobData> {
        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * 
         * @param actionTypeId
         *        Represents information about an action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypeId(ActionTypeId actionTypeId);

        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeId.Builder} avoiding the need
         * to create one manually via {@link ActionTypeId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypeId(ActionTypeId)}.
         * 
         * @param actionTypeId
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypeId(ActionTypeId)
         */
        default Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return actionTypeId(ActionTypeId.builder().applyMutation(actionTypeId).build());
        }

        /**
         * <p>
         * Represents information about an action configuration.
         * </p>
         * 
         * @param actionConfiguration
         *        Represents information about an action configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfiguration(ActionConfiguration actionConfiguration);

        /**
         * <p>
         * Represents information about an action configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionConfiguration.Builder} avoiding the
         * need to create one manually via {@link ActionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #actionConfiguration(ActionConfiguration)}.
         * 
         * @param actionConfiguration
         *        a consumer that will call methods on {@link ActionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConfiguration(ActionConfiguration)
         */
        default Builder actionConfiguration(Consumer<ActionConfiguration.Builder> actionConfiguration) {
            return actionConfiguration(ActionConfiguration.builder().applyMutation(actionConfiguration).build());
        }

        /**
         * <p>
         * Represents information about a pipeline to a job worker.
         * </p>
         * <note>
         * <p>
         * Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.
         * </p>
         * </note>
         * 
         * @param pipelineContext
         *        Represents information about a pipeline to a job worker.</p> <note>
         *        <p>
         *        Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineContext(PipelineContext pipelineContext);

        /**
         * <p>
         * Represents information about a pipeline to a job worker.
         * </p>
         * <note>
         * <p>
         * Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link PipelineContext.Builder} avoiding
         * the need to create one manually via {@link PipelineContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineContext.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineContext(PipelineContext)}.
         * 
         * @param pipelineContext
         *        a consumer that will call methods on {@link PipelineContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineContext(PipelineContext)
         */
        default Builder pipelineContext(Consumer<PipelineContext.Builder> pipelineContext) {
            return pipelineContext(PipelineContext.builder().applyMutation(pipelineContext).build());
        }

        /**
         * <p>
         * The name of the artifact that is worked on by the action, if any. This name might be system-generated, such
         * as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match
         * the name of an output artifact generated by an action in an earlier action or stage of the pipeline.
         * </p>
         * 
         * @param inputArtifacts
         *        The name of the artifact that is worked on by the action, if any. This name might be system-generated,
         *        such as "MyApp", or it might be defined by the user when the action is created. The input artifact
         *        name must match the name of an output artifact generated by an action in an earlier action or stage of
         *        the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Collection<Artifact> inputArtifacts);

        /**
         * <p>
         * The name of the artifact that is worked on by the action, if any. This name might be system-generated, such
         * as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match
         * the name of an output artifact generated by an action in an earlier action or stage of the pipeline.
         * </p>
         * 
         * @param inputArtifacts
         *        The name of the artifact that is worked on by the action, if any. This name might be system-generated,
         *        such as "MyApp", or it might be defined by the user when the action is created. The input artifact
         *        name must match the name of an output artifact generated by an action in an earlier action or stage of
         *        the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Artifact... inputArtifacts);

        /**
         * <p>
         * The name of the artifact that is worked on by the action, if any. This name might be system-generated, such
         * as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match
         * the name of an output artifact generated by an action in an earlier action or stage of the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codepipeline.model.Artifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder#build()} is called immediately and
         * its result is passed to {@link #inputArtifacts(List<Artifact>)}.
         * 
         * @param inputArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifacts(java.util.Collection<Artifact>)
         */
        Builder inputArtifacts(Consumer<Artifact.Builder>... inputArtifacts);

        /**
         * <p>
         * The name of the artifact that is the result of the action, if any. This name might be system-generated, such
         * as "MyBuiltApp", or it might be defined by the user when the action is created.
         * </p>
         * 
         * @param outputArtifacts
         *        The name of the artifact that is the result of the action, if any. This name might be
         *        system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Collection<Artifact> outputArtifacts);

        /**
         * <p>
         * The name of the artifact that is the result of the action, if any. This name might be system-generated, such
         * as "MyBuiltApp", or it might be defined by the user when the action is created.
         * </p>
         * 
         * @param outputArtifacts
         *        The name of the artifact that is the result of the action, if any. This name might be
         *        system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Artifact... outputArtifacts);

        /**
         * <p>
         * The name of the artifact that is the result of the action, if any. This name might be system-generated, such
         * as "MyBuiltApp", or it might be defined by the user when the action is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codepipeline.model.Artifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder#build()} is called immediately and
         * its result is passed to {@link #outputArtifacts(List<Artifact>)}.
         * 
         * @param outputArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.Artifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputArtifacts(java.util.Collection<Artifact>)
         */
        Builder outputArtifacts(Consumer<Artifact.Builder>... outputArtifacts);

        /**
         * <p>
         * Represents an Amazon Web Services session credentials object. These credentials are temporary credentials
         * that are issued by Amazon Web Services Secure Token Service (STS). They can be used to access input and
         * output artifacts in the S3 bucket used to store artifact for the pipeline in CodePipeline.
         * </p>
         * 
         * @param artifactCredentials
         *        Represents an Amazon Web Services session credentials object. These credentials are temporary
         *        credentials that are issued by Amazon Web Services Secure Token Service (STS). They can be used to
         *        access input and output artifacts in the S3 bucket used to store artifact for the pipeline in
         *        CodePipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactCredentials(AWSSessionCredentials artifactCredentials);

        /**
         * <p>
         * Represents an Amazon Web Services session credentials object. These credentials are temporary credentials
         * that are issued by Amazon Web Services Secure Token Service (STS). They can be used to access input and
         * output artifacts in the S3 bucket used to store artifact for the pipeline in CodePipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link AWSSessionCredentials.Builder} avoiding
         * the need to create one manually via {@link AWSSessionCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AWSSessionCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #artifactCredentials(AWSSessionCredentials)}.
         * 
         * @param artifactCredentials
         *        a consumer that will call methods on {@link AWSSessionCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactCredentials(AWSSessionCredentials)
         */
        default Builder artifactCredentials(Consumer<AWSSessionCredentials.Builder> artifactCredentials) {
            return artifactCredentials(AWSSessionCredentials.builder().applyMutation(artifactCredentials).build());
        }

        /**
         * <p>
         * A system-generated token, such as a CodeDeploy deployment ID, that a job requires to continue the job
         * asynchronously.
         * </p>
         * 
         * @param continuationToken
         *        A system-generated token, such as a CodeDeploy deployment ID, that a job requires to continue the job
         *        asynchronously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an Amazon
         * Web Services Key Management Service (Amazon Web Services KMS) key. This is optional and might not be present.
         * </p>
         * 
         * @param encryptionKey
         *        The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an
         *        Amazon Web Services Key Management Service (Amazon Web Services KMS) key. This is optional and might
         *        not be present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(EncryptionKey encryptionKey);

        /**
         * <p>
         * The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an Amazon
         * Web Services Key Management Service (Amazon Web Services KMS) key. This is optional and might not be present.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionKey.Builder} avoiding the need
         * to create one manually via {@link EncryptionKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionKey.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionKey(EncryptionKey)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link EncryptionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(EncryptionKey)
         */
        default Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return encryptionKey(EncryptionKey.builder().applyMutation(encryptionKey).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActionTypeId actionTypeId;

        private ActionConfiguration actionConfiguration;

        private PipelineContext pipelineContext;

        private List<Artifact> inputArtifacts = DefaultSdkAutoConstructList.getInstance();

        private List<Artifact> outputArtifacts = DefaultSdkAutoConstructList.getInstance();

        private AWSSessionCredentials artifactCredentials;

        private String continuationToken;

        private EncryptionKey encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartyJobData model) {
            actionTypeId(model.actionTypeId);
            actionConfiguration(model.actionConfiguration);
            pipelineContext(model.pipelineContext);
            inputArtifacts(model.inputArtifacts);
            outputArtifacts(model.outputArtifacts);
            artifactCredentials(model.artifactCredentials);
            continuationToken(model.continuationToken);
            encryptionKey(model.encryptionKey);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return actionTypeId != null ? actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final ActionConfiguration.Builder getActionConfiguration() {
            return actionConfiguration != null ? actionConfiguration.toBuilder() : null;
        }

        public final void setActionConfiguration(ActionConfiguration.BuilderImpl actionConfiguration) {
            this.actionConfiguration = actionConfiguration != null ? actionConfiguration.build() : null;
        }

        @Override
        public final Builder actionConfiguration(ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
            return this;
        }

        public final PipelineContext.Builder getPipelineContext() {
            return pipelineContext != null ? pipelineContext.toBuilder() : null;
        }

        public final void setPipelineContext(PipelineContext.BuilderImpl pipelineContext) {
            this.pipelineContext = pipelineContext != null ? pipelineContext.build() : null;
        }

        @Override
        public final Builder pipelineContext(PipelineContext pipelineContext) {
            this.pipelineContext = pipelineContext;
            return this;
        }

        public final List<Artifact.Builder> getInputArtifacts() {
            List<Artifact.Builder> result = ArtifactListCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Collection<Artifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Collection<Artifact> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Artifact... inputArtifacts) {
            inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<Artifact.Builder>... inputArtifacts) {
            inputArtifacts(Stream.of(inputArtifacts).map(c -> Artifact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Artifact.Builder> getOutputArtifacts() {
            List<Artifact.Builder> result = ArtifactListCopier.copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Collection<Artifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Collection<Artifact> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Artifact... outputArtifacts) {
            outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<Artifact.Builder>... outputArtifacts) {
            outputArtifacts(Stream.of(outputArtifacts).map(c -> Artifact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AWSSessionCredentials.Builder getArtifactCredentials() {
            return artifactCredentials != null ? artifactCredentials.toBuilder() : null;
        }

        public final void setArtifactCredentials(AWSSessionCredentials.BuilderImpl artifactCredentials) {
            this.artifactCredentials = artifactCredentials != null ? artifactCredentials.build() : null;
        }

        @Override
        public final Builder artifactCredentials(AWSSessionCredentials artifactCredentials) {
            this.artifactCredentials = artifactCredentials;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Override
        public ThirdPartyJobData build() {
            return new ThirdPartyJobData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
