/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<GetQueryResultsResponse.Builder, GetQueryResultsResponse> {
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(GetQueryResultsResponse::queryStatusAsString))
            .setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final SdkField<QueryStatistics> QUERY_STATISTICS_FIELD = SdkField
            .<QueryStatistics> builder(MarshallingType.SDK_POJO).memberName("QueryStatistics")
            .getter(getter(GetQueryResultsResponse::queryStatistics)).setter(setter(Builder::queryStatistics))
            .constructor(QueryStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatistics").build()).build();

    private static final SdkField<List<List<Map<String, String>>>> QUERY_RESULT_ROWS_FIELD = SdkField
            .<List<List<Map<String, String>>>> builder(MarshallingType.LIST)
            .memberName("QueryResultRows")
            .getter(getter(GetQueryResultsResponse::queryResultRows))
            .setter(setter(Builder::queryResultRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultRows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Map<String, String>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    MapTrait.builder()
                                                                                            .keyLocationName("key")
                                                                                            .valueLocationName("value")
                                                                                            .valueFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "value")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetQueryResultsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(GetQueryResultsResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATUS_FIELD,
            QUERY_STATISTICS_FIELD, QUERY_RESULT_ROWS_FIELD, NEXT_TOKEN_FIELD, ERROR_MESSAGE_FIELD));

    private final String queryStatus;

    private final QueryStatistics queryStatistics;

    private final List<List<Map<String, String>>> queryResultRows;

    private final String nextToken;

    private final String errorMessage;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.queryStatus = builder.queryStatus;
        this.queryStatistics = builder.queryStatistics;
        this.queryResultRows = builder.queryResultRows;
        this.nextToken = builder.nextToken;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     *         <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
     *         <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    /**
     * <p>
     * Shows the count of query results.
     * </p>
     * 
     * @return Shows the count of query results.
     */
    public final QueryStatistics queryStatistics() {
        return queryStatistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryResultRows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryResultRows() {
        return queryResultRows != null && !(queryResultRows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the individual event results of the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryResultRows} method.
     * </p>
     * 
     * @return Contains the individual event results of the query.
     */
    public final List<List<Map<String, String>>> queryResultRows() {
        return queryResultRows;
    }

    /**
     * <p>
     * A token you can use to get the next page of query results.
     * </p>
     * 
     * @return A token you can use to get the next page of query results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The error message returned if a query failed.
     * </p>
     * 
     * @return The error message returned if a query failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryResultRows() ? queryResultRows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse) obj;
        return Objects.equals(queryStatusAsString(), other.queryStatusAsString())
                && Objects.equals(queryStatistics(), other.queryStatistics())
                && hasQueryResultRows() == other.hasQueryResultRows()
                && Objects.equals(queryResultRows(), other.queryResultRows()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryResultsResponse").add("QueryStatus", queryStatusAsString())
                .add("QueryStatistics", queryStatistics())
                .add("QueryResultRows", hasQueryResultRows() ? queryResultRows() : null).add("NextToken", nextToken())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        case "QueryStatistics":
            return Optional.ofNullable(clazz.cast(queryStatistics()));
        case "QueryResultRows":
            return Optional.ofNullable(clazz.cast(queryResultRows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryResultsResponse> {
        /**
         * <p>
         * The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>,
         *        <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>, <code>FINISHED</code>,
         * <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        The status of the query. Values include <code>QUEUED</code>, <code>RUNNING</code>,
         *        <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(QueryStatus queryStatus);

        /**
         * <p>
         * Shows the count of query results.
         * </p>
         * 
         * @param queryStatistics
         *        Shows the count of query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatistics(QueryStatistics queryStatistics);

        /**
         * <p>
         * Shows the count of query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryStatistics.Builder} avoiding the
         * need to create one manually via {@link QueryStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #queryStatistics(QueryStatistics)}.
         * 
         * @param queryStatistics
         *        a consumer that will call methods on {@link QueryStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStatistics(QueryStatistics)
         */
        default Builder queryStatistics(Consumer<QueryStatistics.Builder> queryStatistics) {
            return queryStatistics(QueryStatistics.builder().applyMutation(queryStatistics).build());
        }

        /**
         * <p>
         * Contains the individual event results of the query.
         * </p>
         * 
         * @param queryResultRows
         *        Contains the individual event results of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryResultRows(Collection<? extends Collection<? extends Map<String, String>>> queryResultRows);

        /**
         * <p>
         * Contains the individual event results of the query.
         * </p>
         * 
         * @param queryResultRows
         *        Contains the individual event results of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryResultRows(Collection<? extends Map<String, String>>... queryResultRows);

        /**
         * <p>
         * A token you can use to get the next page of query results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use to get the next page of query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The error message returned if a query failed.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned if a query failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String queryStatus;

        private QueryStatistics queryStatistics;

        private List<List<Map<String, String>>> queryResultRows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            queryStatus(model.queryStatus);
            queryStatistics(model.queryStatistics);
            queryResultRows(model.queryResultRows);
            nextToken(model.nextToken);
            errorMessage(model.errorMessage);
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final QueryStatistics.Builder getQueryStatistics() {
            return queryStatistics != null ? queryStatistics.toBuilder() : null;
        }

        public final void setQueryStatistics(QueryStatistics.BuilderImpl queryStatistics) {
            this.queryStatistics = queryStatistics != null ? queryStatistics.build() : null;
        }

        @Override
        public final Builder queryStatistics(QueryStatistics queryStatistics) {
            this.queryStatistics = queryStatistics;
            return this;
        }

        public final Collection<? extends Collection<? extends Map<String, String>>> getQueryResultRows() {
            if (queryResultRows instanceof SdkAutoConstructList) {
                return null;
            }
            return queryResultRows;
        }

        public final void setQueryResultRows(Collection<? extends Collection<? extends Map<String, String>>> queryResultRows) {
            this.queryResultRows = QueryResultRowsCopier.copy(queryResultRows);
        }

        @Override
        public final Builder queryResultRows(Collection<? extends Collection<? extends Map<String, String>>> queryResultRows) {
            this.queryResultRows = QueryResultRowsCopier.copy(queryResultRows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryResultRows(Collection<? extends Map<String, String>>... queryResultRows) {
            queryResultRows(Arrays.asList(queryResultRows));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
