/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are
 * enabled for a given CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringSubscription.Builder, MonitoringSubscription> {
    private static final SdkField<RealtimeMetricsSubscriptionConfig> REALTIME_METRICS_SUBSCRIPTION_CONFIG_FIELD = SdkField
            .<RealtimeMetricsSubscriptionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("RealtimeMetricsSubscriptionConfig")
            .getter(getter(MonitoringSubscription::realtimeMetricsSubscriptionConfig))
            .setter(setter(Builder::realtimeMetricsSubscriptionConfig))
            .constructor(RealtimeMetricsSubscriptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeMetricsSubscriptionConfig")
                    .unmarshallLocationName("RealtimeMetricsSubscriptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REALTIME_METRICS_SUBSCRIPTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig;

    private MonitoringSubscription(BuilderImpl builder) {
        this.realtimeMetricsSubscriptionConfig = builder.realtimeMetricsSubscriptionConfig;
    }

    /**
     * <p>
     * A subscription configuration for additional CloudWatch metrics.
     * </p>
     * 
     * @return A subscription configuration for additional CloudWatch metrics.
     */
    public final RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig() {
        return realtimeMetricsSubscriptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(realtimeMetricsSubscriptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringSubscription)) {
            return false;
        }
        MonitoringSubscription other = (MonitoringSubscription) obj;
        return Objects.equals(realtimeMetricsSubscriptionConfig(), other.realtimeMetricsSubscriptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringSubscription")
                .add("RealtimeMetricsSubscriptionConfig", realtimeMetricsSubscriptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RealtimeMetricsSubscriptionConfig":
            return Optional.ofNullable(clazz.cast(realtimeMetricsSubscriptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringSubscription, T> g) {
        return obj -> g.apply((MonitoringSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringSubscription> {
        /**
         * <p>
         * A subscription configuration for additional CloudWatch metrics.
         * </p>
         * 
         * @param realtimeMetricsSubscriptionConfig
         *        A subscription configuration for additional CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig);

        /**
         * <p>
         * A subscription configuration for additional CloudWatch metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RealtimeMetricsSubscriptionConfig.Builder} avoiding the need to create one manually via
         * {@link RealtimeMetricsSubscriptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealtimeMetricsSubscriptionConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfig)}.
         * 
         * @param realtimeMetricsSubscriptionConfig
         *        a consumer that will call methods on {@link RealtimeMetricsSubscriptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfig)
         */
        default Builder realtimeMetricsSubscriptionConfig(
                Consumer<RealtimeMetricsSubscriptionConfig.Builder> realtimeMetricsSubscriptionConfig) {
            return realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfig.builder()
                    .applyMutation(realtimeMetricsSubscriptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringSubscription model) {
            realtimeMetricsSubscriptionConfig(model.realtimeMetricsSubscriptionConfig);
        }

        public final RealtimeMetricsSubscriptionConfig.Builder getRealtimeMetricsSubscriptionConfig() {
            return realtimeMetricsSubscriptionConfig != null ? realtimeMetricsSubscriptionConfig.toBuilder() : null;
        }

        public final void setRealtimeMetricsSubscriptionConfig(
                RealtimeMetricsSubscriptionConfig.BuilderImpl realtimeMetricsSubscriptionConfig) {
            this.realtimeMetricsSubscriptionConfig = realtimeMetricsSubscriptionConfig != null ? realtimeMetricsSubscriptionConfig
                    .build() : null;
        }

        @Override
        public final Builder realtimeMetricsSubscriptionConfig(RealtimeMetricsSubscriptionConfig realtimeMetricsSubscriptionConfig) {
            this.realtimeMetricsSubscriptionConfig = realtimeMetricsSubscriptionConfig;
            return this;
        }

        @Override
        public MonitoringSubscription build() {
            return new MonitoringSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
