/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BatchReadOperationResponseListCopier {
    static List<BatchReadOperationResponse> copy(
            Collection<? extends BatchReadOperationResponse> batchReadOperationResponseListParam) {
        List<BatchReadOperationResponse> list;
        if (batchReadOperationResponseListParam == null || batchReadOperationResponseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchReadOperationResponse> modifiableList = new ArrayList<>();
            batchReadOperationResponseListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchReadOperationResponse> copyFromBuilder(
            Collection<? extends BatchReadOperationResponse.Builder> batchReadOperationResponseListParam) {
        List<BatchReadOperationResponse> list;
        if (batchReadOperationResponseListParam == null || batchReadOperationResponseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchReadOperationResponse> modifiableList = new ArrayList<>();
            batchReadOperationResponseListParam.forEach(entry -> {
                BatchReadOperationResponse member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BatchReadOperationResponse.Builder> copyToBuilder(
            Collection<? extends BatchReadOperationResponse> batchReadOperationResponseListParam) {
        List<BatchReadOperationResponse.Builder> list;
        if (batchReadOperationResponseListParam == null || batchReadOperationResponseListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BatchReadOperationResponse.Builder> modifiableList = new ArrayList<>();
            batchReadOperationResponseListParam.forEach(entry -> {
                BatchReadOperationResponse.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
