/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends Cloud9Request implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateEnvironmentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MANAGED_CREDENTIALS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedCredentialsAction").getter(getter(UpdateEnvironmentRequest::managedCredentialsActionAsString))
            .setter(setter(Builder::managedCredentialsAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedCredentialsAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, MANAGED_CREDENTIALS_ACTION_FIELD));

    private final String environmentId;

    private final String name;

    private final String description;

    private final String managedCredentialsAction;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.managedCredentialsAction = builder.managedCredentialsAction;
    }

    /**
     * <p>
     * The ID of the environment to change settings.
     * </p>
     * 
     * @return The ID of the environment to change settings.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A replacement name for the environment.
     * </p>
     * 
     * @return A replacement name for the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Any new or replacement description for the environment.
     * </p>
     * 
     * @return Any new or replacement description for the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for an
     * Cloud9 environment by using one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only the environment owner can change the status of managed temporary credentials. An
     * <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials
     * is made by an account that's not the environment owner.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedCredentialsAction} will return {@link ManagedCredentialsAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #managedCredentialsActionAsString}.
     * </p>
     * 
     * @return Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials
     *         for an Cloud9 environment by using one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only the environment owner can change the status of managed temporary credentials. An
     *         <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
     *         credentials is made by an account that's not the environment owner.
     *         </p>
     * @see ManagedCredentialsAction
     */
    public final ManagedCredentialsAction managedCredentialsAction() {
        return ManagedCredentialsAction.fromValue(managedCredentialsAction);
    }

    /**
     * <p>
     * Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for an
     * Cloud9 environment by using one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLE</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only the environment owner can change the status of managed temporary credentials. An
     * <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary credentials
     * is made by an account that's not the environment owner.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedCredentialsAction} will return {@link ManagedCredentialsAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #managedCredentialsActionAsString}.
     * </p>
     * 
     * @return Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials
     *         for an Cloud9 environment by using one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLE</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only the environment owner can change the status of managed temporary credentials. An
     *         <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
     *         credentials is made by an account that's not the environment owner.
     *         </p>
     * @see ManagedCredentialsAction
     */
    public final String managedCredentialsActionAsString() {
        return managedCredentialsAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(managedCredentialsActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(managedCredentialsActionAsString(), other.managedCredentialsActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentRequest").add("EnvironmentId", environmentId()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ManagedCredentialsAction", managedCredentialsActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "managedCredentialsAction":
            return Optional.ofNullable(clazz.cast(managedCredentialsActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The ID of the environment to change settings.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment to change settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A replacement name for the environment.
         * </p>
         * 
         * @param name
         *        A replacement name for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Any new or replacement description for the environment.
         * </p>
         * 
         * @param description
         *        Any new or replacement description for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for
         * an Cloud9 environment by using one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only the environment owner can change the status of managed temporary credentials. An
         * <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
         * credentials is made by an account that's not the environment owner.
         * </p>
         * </note>
         * 
         * @param managedCredentialsAction
         *        Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary
         *        credentials for an Cloud9 environment by using one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only the environment owner can change the status of managed temporary credentials. An
         *        <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
         *        credentials is made by an account that's not the environment owner.
         *        </p>
         * @see ManagedCredentialsAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCredentialsAction
         */
        Builder managedCredentialsAction(String managedCredentialsAction);

        /**
         * <p>
         * Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary credentials for
         * an Cloud9 environment by using one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLE</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only the environment owner can change the status of managed temporary credentials. An
         * <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
         * credentials is made by an account that's not the environment owner.
         * </p>
         * </note>
         * 
         * @param managedCredentialsAction
         *        Allows the environment owner to turn on or turn off the Amazon Web Services managed temporary
         *        credentials for an Cloud9 environment by using one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLE</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only the environment owner can change the status of managed temporary credentials. An
         *        <code>AccessDeniedException</code> is thrown if an attempt to turn on or turn off managed temporary
         *        credentials is made by an account that's not the environment owner.
         *        </p>
         * @see ManagedCredentialsAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCredentialsAction
         */
        Builder managedCredentialsAction(ManagedCredentialsAction managedCredentialsAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Cloud9Request.BuilderImpl implements Builder {
        private String environmentId;

        private String name;

        private String description;

        private String managedCredentialsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            environmentId(model.environmentId);
            name(model.name);
            description(model.description);
            managedCredentialsAction(model.managedCredentialsAction);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManagedCredentialsAction() {
            return managedCredentialsAction;
        }

        public final void setManagedCredentialsAction(String managedCredentialsAction) {
            this.managedCredentialsAction = managedCredentialsAction;
        }

        @Override
        public final Builder managedCredentialsAction(String managedCredentialsAction) {
            this.managedCredentialsAction = managedCredentialsAction;
            return this;
        }

        @Override
        public final Builder managedCredentialsAction(ManagedCredentialsAction managedCredentialsAction) {
            this.managedCredentialsAction(managedCredentialsAction == null ? null : managedCredentialsAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
