/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retention settings that determine how long to retain conversation messages for an Amazon Chime Enterprise
 * account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationRetentionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationRetentionSettings.Builder, ConversationRetentionSettings> {
    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionDays").getter(getter(ConversationRetentionSettings::retentionDays))
            .setter(setter(Builder::retentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer retentionDays;

    private ConversationRetentionSettings(BuilderImpl builder) {
        this.retentionDays = builder.retentionDays;
    }

    /**
     * <p>
     * The number of days for which to retain conversation messages.
     * </p>
     * 
     * @return The number of days for which to retain conversation messages.
     */
    public final Integer retentionDays() {
        return retentionDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationRetentionSettings)) {
            return false;
        }
        ConversationRetentionSettings other = (ConversationRetentionSettings) obj;
        return Objects.equals(retentionDays(), other.retentionDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationRetentionSettings").add("RetentionDays", retentionDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionDays":
            return Optional.ofNullable(clazz.cast(retentionDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationRetentionSettings, T> g) {
        return obj -> g.apply((ConversationRetentionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationRetentionSettings> {
        /**
         * <p>
         * The number of days for which to retain conversation messages.
         * </p>
         * 
         * @param retentionDays
         *        The number of days for which to retain conversation messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionDays(Integer retentionDays);
    }

    static final class BuilderImpl implements Builder {
        private Integer retentionDays;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationRetentionSettings model) {
            retentionDays(model.retentionDays);
        }

        public final Integer getRetentionDays() {
            return retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        @Override
        public ConversationRetentionSettings build() {
            return new ConversationRetentionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
