/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon EKS volume for a job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksVolume implements SdkPojo, Serializable, ToCopyableBuilder<EksVolume.Builder, EksVolume> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EksVolume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<EksHostPath> HOST_PATH_FIELD = SdkField.<EksHostPath> builder(MarshallingType.SDK_POJO)
            .memberName("hostPath").getter(getter(EksVolume::hostPath)).setter(setter(Builder::hostPath))
            .constructor(EksHostPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPath").build()).build();

    private static final SdkField<EksEmptyDir> EMPTY_DIR_FIELD = SdkField.<EksEmptyDir> builder(MarshallingType.SDK_POJO)
            .memberName("emptyDir").getter(getter(EksVolume::emptyDir)).setter(setter(Builder::emptyDir))
            .constructor(EksEmptyDir::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyDir").build()).build();

    private static final SdkField<EksSecret> SECRET_FIELD = SdkField.<EksSecret> builder(MarshallingType.SDK_POJO)
            .memberName("secret").getter(getter(EksVolume::secret)).setter(setter(Builder::secret))
            .constructor(EksSecret::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_PATH_FIELD,
            EMPTY_DIR_FIELD, SECRET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final EksHostPath hostPath;

    private final EksEmptyDir emptyDir;

    private final EksSecret secret;

    private EksVolume(BuilderImpl builder) {
        this.name = builder.name;
        this.hostPath = builder.hostPath;
        this.emptyDir = builder.emptyDir;
        this.secret = builder.secret;
    }

    /**
     * <p>
     * The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain
     * names</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
     *         subdomain names</a> in the <i>Kubernetes documentation</i>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the configuration of a Kubernetes <code>hostPath</code> volume. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <i>Kubernetes
     * documentation</i>.
     * </p>
     * 
     * @return Specifies the configuration of a Kubernetes <code>hostPath</code> volume. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <i>Kubernetes
     *         documentation</i>.
     */
    public final EksHostPath hostPath() {
        return hostPath;
    }

    /**
     * <p>
     * Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
     * documentation</i>.
     * </p>
     * 
     * @return Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
     *         documentation</i>.
     */
    public final EksEmptyDir emptyDir() {
        return emptyDir;
    }

    /**
     * <p>
     * Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes
     * documentation</i>.
     * </p>
     * 
     * @return Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes
     *         documentation</i>.
     */
    public final EksSecret secret() {
        return secret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hostPath());
        hashCode = 31 * hashCode + Objects.hashCode(emptyDir());
        hashCode = 31 * hashCode + Objects.hashCode(secret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksVolume)) {
            return false;
        }
        EksVolume other = (EksVolume) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(hostPath(), other.hostPath())
                && Objects.equals(emptyDir(), other.emptyDir()) && Objects.equals(secret(), other.secret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksVolume").add("Name", name()).add("HostPath", hostPath()).add("EmptyDir", emptyDir())
                .add("Secret", secret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "hostPath":
            return Optional.ofNullable(clazz.cast(hostPath()));
        case "emptyDir":
            return Optional.ofNullable(clazz.cast(emptyDir()));
        case "secret":
            return Optional.ofNullable(clazz.cast(secret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksVolume, T> g) {
        return obj -> g.apply((EksVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksVolume> {
        /**
         * <p>
         * The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
         * subdomain names</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param name
         *        The name of the volume. The name must be allowed as a DNS subdomain name. For more information, see <a
         *        href
         *        ="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
         *        subdomain names</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>hostPath</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * 
         * @param hostPath
         *        Specifies the configuration of a Kubernetes <code>hostPath</code> volume. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <i>Kubernetes
         *        documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostPath(EksHostPath hostPath);

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>hostPath</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksHostPath.Builder} avoiding the need to
         * create one manually via {@link EksHostPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksHostPath.Builder#build()} is called immediately and its result
         * is passed to {@link #hostPath(EksHostPath)}.
         * 
         * @param hostPath
         *        a consumer that will call methods on {@link EksHostPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostPath(EksHostPath)
         */
        default Builder hostPath(Consumer<EksHostPath.Builder> hostPath) {
            return hostPath(EksHostPath.builder().applyMutation(hostPath).build());
        }

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * 
         * @param emptyDir
         *        Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
         *        documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyDir(EksEmptyDir emptyDir);

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksEmptyDir.Builder} avoiding the need to
         * create one manually via {@link EksEmptyDir#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksEmptyDir.Builder#build()} is called immediately and its result
         * is passed to {@link #emptyDir(EksEmptyDir)}.
         * 
         * @param emptyDir
         *        a consumer that will call methods on {@link EksEmptyDir.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emptyDir(EksEmptyDir)
         */
        default Builder emptyDir(Consumer<EksEmptyDir.Builder> emptyDir) {
            return emptyDir(EksEmptyDir.builder().applyMutation(emptyDir).build());
        }

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * 
         * @param secret
         *        Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes
         *        documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secret(EksSecret secret);

        /**
         * <p>
         * Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes
         * documentation</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksSecret.Builder} avoiding the need to
         * create one manually via {@link EksSecret#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksSecret.Builder#build()} is called immediately and its result
         * is passed to {@link #secret(EksSecret)}.
         * 
         * @param secret
         *        a consumer that will call methods on {@link EksSecret.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secret(EksSecret)
         */
        default Builder secret(Consumer<EksSecret.Builder> secret) {
            return secret(EksSecret.builder().applyMutation(secret).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private EksHostPath hostPath;

        private EksEmptyDir emptyDir;

        private EksSecret secret;

        private BuilderImpl() {
        }

        private BuilderImpl(EksVolume model) {
            name(model.name);
            hostPath(model.hostPath);
            emptyDir(model.emptyDir);
            secret(model.secret);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EksHostPath.Builder getHostPath() {
            return hostPath != null ? hostPath.toBuilder() : null;
        }

        public final void setHostPath(EksHostPath.BuilderImpl hostPath) {
            this.hostPath = hostPath != null ? hostPath.build() : null;
        }

        @Override
        public final Builder hostPath(EksHostPath hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        public final EksEmptyDir.Builder getEmptyDir() {
            return emptyDir != null ? emptyDir.toBuilder() : null;
        }

        public final void setEmptyDir(EksEmptyDir.BuilderImpl emptyDir) {
            this.emptyDir = emptyDir != null ? emptyDir.build() : null;
        }

        @Override
        public final Builder emptyDir(EksEmptyDir emptyDir) {
            this.emptyDir = emptyDir;
            return this;
        }

        public final EksSecret.Builder getSecret() {
            return secret != null ? secret.toBuilder() : null;
        }

        public final void setSecret(EksSecret.BuilderImpl secret) {
            this.secret = secret != null ? secret.build() : null;
        }

        @Override
        public final Builder secret(EksSecret secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public EksVolume build() {
            return new EksVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
