/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReportPlanResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeReportPlanResponse.Builder, DescribeReportPlanResponse> {
    private static final SdkField<ReportPlan> REPORT_PLAN_FIELD = SdkField.<ReportPlan> builder(MarshallingType.SDK_POJO)
            .memberName("ReportPlan").getter(getter(DescribeReportPlanResponse::reportPlan)).setter(setter(Builder::reportPlan))
            .constructor(ReportPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_FIELD));

    private final ReportPlan reportPlan;

    private DescribeReportPlanResponse(BuilderImpl builder) {
        super(builder);
        this.reportPlan = builder.reportPlan;
    }

    /**
     * <p>
     * Returns details about the report plan that is specified by its name. These details include the report plan's
     * Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last
     * attempted and successful run times.
     * </p>
     * 
     * @return Returns details about the report plan that is specified by its name. These details include the report
     *         plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation
     *         time, and last attempted and successful run times.
     */
    public final ReportPlan reportPlan() {
        return reportPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportPlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportPlanResponse)) {
            return false;
        }
        DescribeReportPlanResponse other = (DescribeReportPlanResponse) obj;
        return Objects.equals(reportPlan(), other.reportPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReportPlanResponse").add("ReportPlan", reportPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlan":
            return Optional.ofNullable(clazz.cast(reportPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportPlanResponse, T> g) {
        return obj -> g.apply((DescribeReportPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReportPlanResponse> {
        /**
         * <p>
         * Returns details about the report plan that is specified by its name. These details include the report plan's
         * Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and
         * last attempted and successful run times.
         * </p>
         * 
         * @param reportPlan
         *        Returns details about the report plan that is specified by its name. These details include the report
         *        plan's Amazon Resource Name (ARN), description, settings, delivery channel, deployment status,
         *        creation time, and last attempted and successful run times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlan(ReportPlan reportPlan);

        /**
         * <p>
         * Returns details about the report plan that is specified by its name. These details include the report plan's
         * Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and
         * last attempted and successful run times.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportPlan.Builder} avoiding the need to
         * create one manually via {@link ReportPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #reportPlan(ReportPlan)}.
         * 
         * @param reportPlan
         *        a consumer that will call methods on {@link ReportPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportPlan(ReportPlan)
         */
        default Builder reportPlan(Consumer<ReportPlan.Builder> reportPlan) {
            return reportPlan(ReportPlan.builder().applyMutation(reportPlan).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private ReportPlan reportPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportPlanResponse model) {
            super(model);
            reportPlan(model.reportPlan);
        }

        public final ReportPlan.Builder getReportPlan() {
            return reportPlan != null ? reportPlan.toBuilder() : null;
        }

        public final void setReportPlan(ReportPlan.BuilderImpl reportPlan) {
            this.reportPlan = reportPlan != null ? reportPlan.build() : null;
        }

        @Override
        public final Builder reportPlan(ReportPlan reportPlan) {
            this.reportPlan = reportPlan;
            return this;
        }

        @Override
        public DescribeReportPlanResponse build() {
            return new DescribeReportPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
