/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to provide Reserved Instance preferences for the recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstanceOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstanceOptions.Builder, ReservedInstanceOptions> {
    private static final SdkField<String> PURCHASING_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("purchasingOption").getter(getter(ReservedInstanceOptions::purchasingOptionAsString))
            .setter(setter(Builder::purchasingOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchasingOption").build()).build();

    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringClass").getter(getter(ReservedInstanceOptions::offeringClassAsString))
            .setter(setter(Builder::offeringClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringClass").build()).build();

    private static final SdkField<String> TERM_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("termLength").getter(getter(ReservedInstanceOptions::termLengthAsString))
            .setter(setter(Builder::termLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PURCHASING_OPTION_FIELD,
            OFFERING_CLASS_FIELD, TERM_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String purchasingOption;

    private final String offeringClass;

    private final String termLength;

    private ReservedInstanceOptions(BuilderImpl builder) {
        this.purchasingOption = builder.purchasingOption;
        this.offeringClass = builder.offeringClass;
        this.termLength = builder.termLength;
    }

    /**
     * <p>
     * The payment plan to use for your Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchasingOption}
     * will return {@link PurchasingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchasingOptionAsString}.
     * </p>
     * 
     * @return The payment plan to use for your Reserved Instance.
     * @see PurchasingOption
     */
    public final PurchasingOption purchasingOption() {
        return PurchasingOption.fromValue(purchasingOption);
    }

    /**
     * <p>
     * The payment plan to use for your Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #purchasingOption}
     * will return {@link PurchasingOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #purchasingOptionAsString}.
     * </p>
     * 
     * @return The payment plan to use for your Reserved Instance.
     * @see PurchasingOption
     */
    public final String purchasingOptionAsString() {
        return purchasingOption;
    }

    /**
     * <p>
     * The flexibility to change the instance types needed for your Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringClassAsString}.
     * </p>
     * 
     * @return The flexibility to change the instance types needed for your Reserved Instance.
     * @see OfferingClass
     */
    public final OfferingClass offeringClass() {
        return OfferingClass.fromValue(offeringClass);
    }

    /**
     * <p>
     * The flexibility to change the instance types needed for your Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringClassAsString}.
     * </p>
     * 
     * @return The flexibility to change the instance types needed for your Reserved Instance.
     * @see OfferingClass
     */
    public final String offeringClassAsString() {
        return offeringClass;
    }

    /**
     * <p>
     * The preferred duration of the Reserved Instance term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termLength} will
     * return {@link TermLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termLengthAsString}.
     * </p>
     * 
     * @return The preferred duration of the Reserved Instance term.
     * @see TermLength
     */
    public final TermLength termLength() {
        return TermLength.fromValue(termLength);
    }

    /**
     * <p>
     * The preferred duration of the Reserved Instance term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termLength} will
     * return {@link TermLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termLengthAsString}.
     * </p>
     * 
     * @return The preferred duration of the Reserved Instance term.
     * @see TermLength
     */
    public final String termLengthAsString() {
        return termLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(purchasingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termLengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceOptions)) {
            return false;
        }
        ReservedInstanceOptions other = (ReservedInstanceOptions) obj;
        return Objects.equals(purchasingOptionAsString(), other.purchasingOptionAsString())
                && Objects.equals(offeringClassAsString(), other.offeringClassAsString())
                && Objects.equals(termLengthAsString(), other.termLengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstanceOptions").add("PurchasingOption", purchasingOptionAsString())
                .add("OfferingClass", offeringClassAsString()).add("TermLength", termLengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "purchasingOption":
            return Optional.ofNullable(clazz.cast(purchasingOptionAsString()));
        case "offeringClass":
            return Optional.ofNullable(clazz.cast(offeringClassAsString()));
        case "termLength":
            return Optional.ofNullable(clazz.cast(termLengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstanceOptions, T> g) {
        return obj -> g.apply((ReservedInstanceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstanceOptions> {
        /**
         * <p>
         * The payment plan to use for your Reserved Instance.
         * </p>
         * 
         * @param purchasingOption
         *        The payment plan to use for your Reserved Instance.
         * @see PurchasingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchasingOption
         */
        Builder purchasingOption(String purchasingOption);

        /**
         * <p>
         * The payment plan to use for your Reserved Instance.
         * </p>
         * 
         * @param purchasingOption
         *        The payment plan to use for your Reserved Instance.
         * @see PurchasingOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchasingOption
         */
        Builder purchasingOption(PurchasingOption purchasingOption);

        /**
         * <p>
         * The flexibility to change the instance types needed for your Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The flexibility to change the instance types needed for your Reserved Instance.
         * @see OfferingClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClass
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The flexibility to change the instance types needed for your Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The flexibility to change the instance types needed for your Reserved Instance.
         * @see OfferingClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClass
         */
        Builder offeringClass(OfferingClass offeringClass);

        /**
         * <p>
         * The preferred duration of the Reserved Instance term.
         * </p>
         * 
         * @param termLength
         *        The preferred duration of the Reserved Instance term.
         * @see TermLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermLength
         */
        Builder termLength(String termLength);

        /**
         * <p>
         * The preferred duration of the Reserved Instance term.
         * </p>
         * 
         * @param termLength
         *        The preferred duration of the Reserved Instance term.
         * @see TermLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermLength
         */
        Builder termLength(TermLength termLength);
    }

    static final class BuilderImpl implements Builder {
        private String purchasingOption;

        private String offeringClass;

        private String termLength;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceOptions model) {
            purchasingOption(model.purchasingOption);
            offeringClass(model.offeringClass);
            termLength(model.termLength);
        }

        public final String getPurchasingOption() {
            return purchasingOption;
        }

        public final void setPurchasingOption(String purchasingOption) {
            this.purchasingOption = purchasingOption;
        }

        @Override
        public final Builder purchasingOption(String purchasingOption) {
            this.purchasingOption = purchasingOption;
            return this;
        }

        @Override
        public final Builder purchasingOption(PurchasingOption purchasingOption) {
            this.purchasingOption(purchasingOption == null ? null : purchasingOption.toString());
            return this;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClass offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getTermLength() {
            return termLength;
        }

        public final void setTermLength(String termLength) {
            this.termLength = termLength;
        }

        @Override
        public final Builder termLength(String termLength) {
            this.termLength = termLength;
            return this;
        }

        @Override
        public final Builder termLength(TermLength termLength) {
            this.termLength(termLength == null ? null : termLength.toString());
            return this;
        }

        @Override
        public ReservedInstanceOptions build() {
            return new ReservedInstanceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
