/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointParams;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointProvider;
import software.amazon.awssdk.services.budgets.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.budgets.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.budgets.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultBudgetsEndpointProvider
implements BudgetsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(BudgetsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultBudgetsEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(BudgetsEndpointParams params, String region) {
        RuleResult result = DefaultBudgetsEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultBudgetsEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(BudgetsEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultBudgetsEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(BudgetsEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(BudgetsEndpointParams params, String region) {
        RuleResult result = DefaultBudgetsEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(BudgetsEndpointParams params, String region) {
        if (region != null) {
            return DefaultBudgetsEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(BudgetsEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.us-east-1.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.global.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isob-east-1").build())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.global.cloud.adc-e.uk")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eu-isoe-west-1").build())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.global.csp.hci.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isof-south-1").build())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.eusc-de-east-1.api.amazonwebservices.eu")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eusc-de-east-1").build())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets.eusc-de-east-1.api.amazonwebservices.eu")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eusc-de-east-1").build())).build());
            }
            RuleResult result = DefaultBudgetsEndpointProvider.endpointRule15(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultBudgetsEndpointProvider.endpointRule19(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultBudgetsEndpointProvider.endpointRule23(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultBudgetsEndpointProvider.endpointRule16(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets-fips." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultBudgetsEndpointProvider.endpointRule20(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets-fips." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultBudgetsEndpointProvider.endpointRule24(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(BudgetsEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://budgets." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

