/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.Action;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse;

public class DescribeBudgetActionsForAccountIterable
implements SdkIterable<DescribeBudgetActionsForAccountResponse> {
    private final BudgetsClient client;
    private final DescribeBudgetActionsForAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBudgetActionsForAccountIterable(BudgetsClient client, DescribeBudgetActionsForAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeBudgetActionsForAccountResponseFetcher();
    }

    public Iterator<DescribeBudgetActionsForAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Action> actions() {
        Function<DescribeBudgetActionsForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.actions() != null) {
                return response.actions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBudgetActionsForAccountResponseFetcher
    implements SyncPageFetcher<DescribeBudgetActionsForAccountResponse> {
        private DescribeBudgetActionsForAccountResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetActionsForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBudgetActionsForAccountResponse nextPage(DescribeBudgetActionsForAccountResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetActionsForAccountIterable.this.client.describeBudgetActionsForAccount(DescribeBudgetActionsForAccountIterable.this.firstRequest);
            }
            return DescribeBudgetActionsForAccountIterable.this.client.describeBudgetActionsForAccount((DescribeBudgetActionsForAccountRequest)((Object)DescribeBudgetActionsForAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

