/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.Action;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBudgetActionResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, DescribeBudgetActionResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DescribeBudgetActionResponse.getter(DescribeBudgetActionResponse::accountId)).setter(DescribeBudgetActionResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(DescribeBudgetActionResponse.getter(DescribeBudgetActionResponse::budgetName)).setter(DescribeBudgetActionResponse.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(DescribeBudgetActionResponse.getter(DescribeBudgetActionResponse::action)).setter(DescribeBudgetActionResponse.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("BudgetName", BUDGET_NAME_FIELD);
            this.put("Action", ACTION_FIELD);
        }
    });
    private final String accountId;
    private final String budgetName;
    private final Action action;

    private DescribeBudgetActionResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.action = builder.action;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final Action action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetActionResponse)) {
            return false;
        }
        DescribeBudgetActionResponse other = (DescribeBudgetActionResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.action(), other.action());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBudgetActionResponse").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("Action", (Object)this.action()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetActionResponse, T> g) {
        return obj -> g.apply((DescribeBudgetActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Action action;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetActionResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.action(model.action);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public DescribeBudgetActionResponse build() {
            return new DescribeBudgetActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBudgetActionResponse> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }
    }
}

