/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BudgetType {
    USAGE("USAGE"),
    COST("COST"),
    RI_UTILIZATION("RI_UTILIZATION"),
    RI_COVERAGE("RI_COVERAGE"),
    SAVINGS_PLANS_UTILIZATION("SAVINGS_PLANS_UTILIZATION"),
    SAVINGS_PLANS_COVERAGE("SAVINGS_PLANS_COVERAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BudgetType> VALUE_MAP;
    private final String value;

    private BudgetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BudgetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BudgetType> knownValues() {
        EnumSet<BudgetType> knownValues = EnumSet.allOf(BudgetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BudgetType.class, BudgetType::toString);
    }
}

