/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoAdjustType {
    HISTORICAL("HISTORICAL"),
    FORECAST("FORECAST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoAdjustType> VALUE_MAP;
    private final String value;

    private AutoAdjustType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoAdjustType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoAdjustType> knownValues() {
        EnumSet<AutoAdjustType> knownValues = EnumSet.allOf(AutoAdjustType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoAdjustType.class, AutoAdjustType::toString);
    }
}

