/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse;

public class DescribeBudgetPerformanceHistoryIterable
implements SdkIterable<DescribeBudgetPerformanceHistoryResponse> {
    private final BudgetsClient client;
    private final DescribeBudgetPerformanceHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBudgetPerformanceHistoryIterable(BudgetsClient client, DescribeBudgetPerformanceHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeBudgetPerformanceHistoryResponseFetcher();
    }

    public Iterator<DescribeBudgetPerformanceHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeBudgetPerformanceHistoryResponseFetcher
    implements SyncPageFetcher<DescribeBudgetPerformanceHistoryResponse> {
        private DescribeBudgetPerformanceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetPerformanceHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBudgetPerformanceHistoryResponse nextPage(DescribeBudgetPerformanceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetPerformanceHistoryIterable.this.client.describeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryIterable.this.firstRequest);
            }
            return DescribeBudgetPerformanceHistoryIterable.this.client.describeBudgetPerformanceHistory((DescribeBudgetPerformanceHistoryRequest)((Object)DescribeBudgetPerformanceHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

