/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BudgetedAndActualAmounts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BudgetedAndActualAmounts> {
    private static final SdkField<Spend> BUDGETED_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BudgetedAmount").getter(BudgetedAndActualAmounts.getter(BudgetedAndActualAmounts::budgetedAmount)).setter(BudgetedAndActualAmounts.setter(Builder::budgetedAmount)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetedAmount").build()}).build();
    private static final SdkField<Spend> ACTUAL_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActualAmount").getter(BudgetedAndActualAmounts.getter(BudgetedAndActualAmounts::actualAmount)).setter(BudgetedAndActualAmounts.setter(Builder::actualAmount)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualAmount").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(BudgetedAndActualAmounts.getter(BudgetedAndActualAmounts::timePeriod)).setter(BudgetedAndActualAmounts.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGETED_AMOUNT_FIELD, ACTUAL_AMOUNT_FIELD, TIME_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Spend budgetedAmount;
    private final Spend actualAmount;
    private final TimePeriod timePeriod;

    private BudgetedAndActualAmounts(BuilderImpl builder) {
        this.budgetedAmount = builder.budgetedAmount;
        this.actualAmount = builder.actualAmount;
        this.timePeriod = builder.timePeriod;
    }

    public final Spend budgetedAmount() {
        return this.budgetedAmount;
    }

    public final Spend actualAmount() {
        return this.actualAmount;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetedAndActualAmounts)) {
            return false;
        }
        BudgetedAndActualAmounts other = (BudgetedAndActualAmounts)obj;
        return Objects.equals(this.budgetedAmount(), other.budgetedAmount()) && Objects.equals(this.actualAmount(), other.actualAmount()) && Objects.equals(this.timePeriod(), other.timePeriod());
    }

    public final String toString() {
        return ToString.builder((String)"BudgetedAndActualAmounts").add("BudgetedAmount", (Object)this.budgetedAmount()).add("ActualAmount", (Object)this.actualAmount()).add("TimePeriod", (Object)this.timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetedAmount": {
                return Optional.ofNullable(clazz.cast(this.budgetedAmount()));
            }
            case "ActualAmount": {
                return Optional.ofNullable(clazz.cast(this.actualAmount()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetedAndActualAmounts, T> g) {
        return obj -> g.apply((BudgetedAndActualAmounts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Spend budgetedAmount;
        private Spend actualAmount;
        private TimePeriod timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetedAndActualAmounts model) {
            this.budgetedAmount(model.budgetedAmount);
            this.actualAmount(model.actualAmount);
            this.timePeriod(model.timePeriod);
        }

        public final Spend.Builder getBudgetedAmount() {
            return this.budgetedAmount != null ? this.budgetedAmount.toBuilder() : null;
        }

        public final void setBudgetedAmount(Spend.BuilderImpl budgetedAmount) {
            this.budgetedAmount = budgetedAmount != null ? budgetedAmount.build() : null;
        }

        @Override
        public final Builder budgetedAmount(Spend budgetedAmount) {
            this.budgetedAmount = budgetedAmount;
            return this;
        }

        public final Spend.Builder getActualAmount() {
            return this.actualAmount != null ? this.actualAmount.toBuilder() : null;
        }

        public final void setActualAmount(Spend.BuilderImpl actualAmount) {
            this.actualAmount = actualAmount != null ? actualAmount.build() : null;
        }

        @Override
        public final Builder actualAmount(Spend actualAmount) {
            this.actualAmount = actualAmount;
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public BudgetedAndActualAmounts build() {
            return new BudgetedAndActualAmounts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BudgetedAndActualAmounts> {
        public Builder budgetedAmount(Spend var1);

        default public Builder budgetedAmount(Consumer<Spend.Builder> budgetedAmount) {
            return this.budgetedAmount((Spend)((Spend.Builder)Spend.builder().applyMutation(budgetedAmount)).build());
        }

        public Builder actualAmount(Spend var1);

        default public Builder actualAmount(Consumer<Spend.Builder> actualAmount) {
            return this.actualAmount((Spend)((Spend.Builder)Spend.builder().applyMutation(actualAmount)).build());
        }

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }
    }
}

