/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointParams;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointProvider;
import software.amazon.awssdk.services.budgets.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.budgets.endpoints.internal.Condition;
import software.amazon.awssdk.services.budgets.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.budgets.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.budgets.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.budgets.endpoints.internal.Expr;
import software.amazon.awssdk.services.budgets.endpoints.internal.FnNode;
import software.amazon.awssdk.services.budgets.endpoints.internal.Identifier;
import software.amazon.awssdk.services.budgets.endpoints.internal.Literal;
import software.amazon.awssdk.services.budgets.endpoints.internal.Parameter;
import software.amazon.awssdk.services.budgets.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.budgets.endpoints.internal.Parameters;
import software.amazon.awssdk.services.budgets.endpoints.internal.Rule;
import software.amazon.awssdk.services.budgets.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultBudgetsEndpointProvider
implements BudgetsEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultBudgetsEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(BudgetsEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultBudgetsEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(BudgetsEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_3() {
        return Rule.builder().treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_4(), DefaultBudgetsEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_2(), DefaultBudgetsEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_8(), DefaultBudgetsEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_12(), DefaultBudgetsEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.{Region}.api.aws")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_16(), DefaultBudgetsEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_7(), DefaultBudgetsEndpointProvider.endpointRule_11(), DefaultBudgetsEndpointProvider.endpointRule_15(), DefaultBudgetsEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.api.amazonwebservices.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_22() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_22(), DefaultBudgetsEndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_26(), DefaultBudgetsEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_31() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.{Region}.api.amazonwebservices.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_31()));
    }

    private static Rule endpointRule_32() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_30(), DefaultBudgetsEndpointProvider.endpointRule_32()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_21(), DefaultBudgetsEndpointProvider.endpointRule_25(), DefaultBudgetsEndpointProvider.endpointRule_29(), DefaultBudgetsEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_36() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_35() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_36()));
    }

    private static Rule endpointRule_37() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_34() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_35(), DefaultBudgetsEndpointProvider.endpointRule_37()));
    }

    private static Rule endpointRule_41() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_40() {
        return Rule.builder().treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_41()));
    }

    private static Rule endpointRule_39() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_40()));
    }

    private static Rule endpointRule_42() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_38() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_39(), DefaultBudgetsEndpointProvider.endpointRule_42()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_45()));
    }

    private static Rule endpointRule_46() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_43() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_44(), DefaultBudgetsEndpointProvider.endpointRule_46()));
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://budgets.amazonaws.com")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_49() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-cn-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://budgets.amazonaws.com.cn")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("cn-northwest-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("budgets")))))).build());
    }

    private static Rule endpointRule_50() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://budgets.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_47() {
        return Rule.builder().treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_48(), DefaultBudgetsEndpointProvider.endpointRule_49(), DefaultBudgetsEndpointProvider.endpointRule_50()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultBudgetsEndpointProvider.endpointRule_1(), DefaultBudgetsEndpointProvider.endpointRule_6(), DefaultBudgetsEndpointProvider.endpointRule_20(), DefaultBudgetsEndpointProvider.endpointRule_34(), DefaultBudgetsEndpointProvider.endpointRule_38(), DefaultBudgetsEndpointProvider.endpointRule_43(), DefaultBudgetsEndpointProvider.endpointRule_47()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultBudgetsEndpointProvider.endpointRule_0()).build();
    }
}

