/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.Subscriber;

public class DescribeSubscribersForNotificationIterable
implements SdkIterable<DescribeSubscribersForNotificationResponse> {
    private final BudgetsClient client;
    private final DescribeSubscribersForNotificationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSubscribersForNotificationIterable(BudgetsClient client, DescribeSubscribersForNotificationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSubscribersForNotificationResponseFetcher();
    }

    public Iterator<DescribeSubscribersForNotificationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscriber> subscribers() {
        Function<DescribeSubscribersForNotificationResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscribers() != null) {
                return response.subscribers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSubscribersForNotificationResponseFetcher
    implements SyncPageFetcher<DescribeSubscribersForNotificationResponse> {
        private DescribeSubscribersForNotificationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubscribersForNotificationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSubscribersForNotificationResponse nextPage(DescribeSubscribersForNotificationResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubscribersForNotificationIterable.this.client.describeSubscribersForNotification(DescribeSubscribersForNotificationIterable.this.firstRequest);
            }
            return DescribeSubscribersForNotificationIterable.this.client.describeSubscribersForNotification((DescribeSubscribersForNotificationRequest)((Object)DescribeSubscribersForNotificationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

