/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.ActionStatus;
import software.amazon.awssdk.services.budgets.model.ActionThreshold;
import software.amazon.awssdk.services.budgets.model.ActionType;
import software.amazon.awssdk.services.budgets.model.ApprovalModel;
import software.amazon.awssdk.services.budgets.model.Definition;
import software.amazon.awssdk.services.budgets.model.NotificationType;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionId").getter(Action.getter(Action::actionId)).setter(Action.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(Action.getter(Action::budgetName)).setter(Action.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationType").getter(Action.getter(Action::notificationTypeAsString)).setter(Action.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(Action.getter(Action::actionTypeAsString)).setter(Action.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<ActionThreshold> ACTION_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActionThreshold").getter(Action.getter(Action::actionThreshold)).setter(Action.setter(Builder::actionThreshold)).constructor(ActionThreshold::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionThreshold").build()}).build();
    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(Action.getter(Action::definition)).setter(Action.setter(Builder::definition)).constructor(Definition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(Action.getter(Action::executionRoleArn)).setter(Action.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> APPROVAL_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalModel").getter(Action.getter(Action::approvalModelAsString)).setter(Action.setter(Builder::approvalModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalModel").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Action.getter(Action::statusAsString)).setter(Action.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(Action.getter(Action::subscribers)).setter(Action.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, BUDGET_NAME_FIELD, NOTIFICATION_TYPE_FIELD, ACTION_TYPE_FIELD, ACTION_THRESHOLD_FIELD, DEFINITION_FIELD, EXECUTION_ROLE_ARN_FIELD, APPROVAL_MODEL_FIELD, STATUS_FIELD, SUBSCRIBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String budgetName;
    private final String notificationType;
    private final String actionType;
    private final ActionThreshold actionThreshold;
    private final Definition definition;
    private final String executionRoleArn;
    private final String approvalModel;
    private final String status;
    private final List<Subscriber> subscribers;

    private Action(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.budgetName = builder.budgetName;
        this.notificationType = builder.notificationType;
        this.actionType = builder.actionType;
        this.actionThreshold = builder.actionThreshold;
        this.definition = builder.definition;
        this.executionRoleArn = builder.executionRoleArn;
        this.approvalModel = builder.approvalModel;
        this.status = builder.status;
        this.subscribers = builder.subscribers;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public final String notificationTypeAsString() {
        return this.notificationType;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final ActionThreshold actionThreshold() {
        return this.actionThreshold;
    }

    public final Definition definition() {
        return this.definition;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final ApprovalModel approvalModel() {
        return ApprovalModel.fromValue(this.approvalModel);
    }

    public final String approvalModelAsString() {
        return this.approvalModel;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public final List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribers() ? this.subscribers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.actionThreshold(), other.actionThreshold()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.approvalModelAsString(), other.approvalModelAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubscribers() == other.hasSubscribers() && Objects.equals(this.subscribers(), other.subscribers());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("ActionId", (Object)this.actionId()).add("BudgetName", (Object)this.budgetName()).add("NotificationType", (Object)this.notificationTypeAsString()).add("ActionType", (Object)this.actionTypeAsString()).add("ActionThreshold", (Object)this.actionThreshold()).add("Definition", (Object)this.definition()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ApprovalModel", (Object)this.approvalModelAsString()).add("Status", (Object)this.statusAsString()).add("Subscribers", this.hasSubscribers() ? this.subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ActionThreshold": {
                return Optional.ofNullable(clazz.cast(this.actionThreshold()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ApprovalModel": {
                return Optional.ofNullable(clazz.cast(this.approvalModelAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String budgetName;
        private String notificationType;
        private String actionType;
        private ActionThreshold actionThreshold;
        private Definition definition;
        private String executionRoleArn;
        private String approvalModel;
        private String status;
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.actionId(model.actionId);
            this.budgetName(model.budgetName);
            this.notificationType(model.notificationType);
            this.actionType(model.actionType);
            this.actionThreshold(model.actionThreshold);
            this.definition(model.definition);
            this.executionRoleArn(model.executionRoleArn);
            this.approvalModel(model.approvalModel);
            this.status(model.status);
            this.subscribers(model.subscribers);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        @Transient
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        @Transient
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        @Transient
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        @Transient
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        @Transient
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final ActionThreshold.Builder getActionThreshold() {
            return this.actionThreshold != null ? this.actionThreshold.toBuilder() : null;
        }

        public final void setActionThreshold(ActionThreshold.BuilderImpl actionThreshold) {
            this.actionThreshold = actionThreshold != null ? actionThreshold.build() : null;
        }

        @Override
        @Transient
        public final Builder actionThreshold(ActionThreshold actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        public final Definition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        @Transient
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getApprovalModel() {
            return this.approvalModel;
        }

        public final void setApprovalModel(String approvalModel) {
            this.approvalModel = approvalModel;
        }

        @Override
        @Transient
        public final Builder approvalModel(String approvalModel) {
            this.approvalModel = approvalModel;
            return this;
        }

        @Override
        @Transient
        public final Builder approvalModel(ApprovalModel approvalModel) {
            this.approvalModel(approvalModel == null ? null : approvalModel.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        @Transient
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder actionId(String var1);

        public Builder budgetName(String var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder actionThreshold(ActionThreshold var1);

        default public Builder actionThreshold(Consumer<ActionThreshold.Builder> actionThreshold) {
            return this.actionThreshold((ActionThreshold)((ActionThreshold.Builder)ActionThreshold.builder().applyMutation(actionThreshold)).build());
        }

        public Builder definition(Definition var1);

        default public Builder definition(Consumer<Definition.Builder> definition) {
            return this.definition((Definition)((Definition.Builder)Definition.builder().applyMutation(definition)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder approvalModel(String var1);

        public Builder approvalModel(ApprovalModel var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);
    }
}

