/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoricalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoricalOptions> {
    private static final SdkField<Integer> BUDGET_ADJUSTMENT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BudgetAdjustmentPeriod").getter(HistoricalOptions.getter(HistoricalOptions::budgetAdjustmentPeriod)).setter(HistoricalOptions.setter(Builder::budgetAdjustmentPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetAdjustmentPeriod").build()}).build();
    private static final SdkField<Integer> LOOK_BACK_AVAILABLE_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LookBackAvailablePeriods").getter(HistoricalOptions.getter(HistoricalOptions::lookBackAvailablePeriods)).setter(HistoricalOptions.setter(Builder::lookBackAvailablePeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackAvailablePeriods").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_ADJUSTMENT_PERIOD_FIELD, LOOK_BACK_AVAILABLE_PERIODS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer budgetAdjustmentPeriod;
    private final Integer lookBackAvailablePeriods;

    private HistoricalOptions(BuilderImpl builder) {
        this.budgetAdjustmentPeriod = builder.budgetAdjustmentPeriod;
        this.lookBackAvailablePeriods = builder.lookBackAvailablePeriods;
    }

    public final Integer budgetAdjustmentPeriod() {
        return this.budgetAdjustmentPeriod;
    }

    public final Integer lookBackAvailablePeriods() {
        return this.lookBackAvailablePeriods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetAdjustmentPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackAvailablePeriods());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalOptions)) {
            return false;
        }
        HistoricalOptions other = (HistoricalOptions)obj;
        return Objects.equals(this.budgetAdjustmentPeriod(), other.budgetAdjustmentPeriod()) && Objects.equals(this.lookBackAvailablePeriods(), other.lookBackAvailablePeriods());
    }

    public final String toString() {
        return ToString.builder((String)"HistoricalOptions").add("BudgetAdjustmentPeriod", (Object)this.budgetAdjustmentPeriod()).add("LookBackAvailablePeriods", (Object)this.lookBackAvailablePeriods()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetAdjustmentPeriod": {
                return Optional.ofNullable(clazz.cast(this.budgetAdjustmentPeriod()));
            }
            case "LookBackAvailablePeriods": {
                return Optional.ofNullable(clazz.cast(this.lookBackAvailablePeriods()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalOptions, T> g) {
        return obj -> g.apply((HistoricalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer budgetAdjustmentPeriod;
        private Integer lookBackAvailablePeriods;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalOptions model) {
            this.budgetAdjustmentPeriod(model.budgetAdjustmentPeriod);
            this.lookBackAvailablePeriods(model.lookBackAvailablePeriods);
        }

        public final Integer getBudgetAdjustmentPeriod() {
            return this.budgetAdjustmentPeriod;
        }

        public final void setBudgetAdjustmentPeriod(Integer budgetAdjustmentPeriod) {
            this.budgetAdjustmentPeriod = budgetAdjustmentPeriod;
        }

        @Override
        @Transient
        public final Builder budgetAdjustmentPeriod(Integer budgetAdjustmentPeriod) {
            this.budgetAdjustmentPeriod = budgetAdjustmentPeriod;
            return this;
        }

        public final Integer getLookBackAvailablePeriods() {
            return this.lookBackAvailablePeriods;
        }

        public final void setLookBackAvailablePeriods(Integer lookBackAvailablePeriods) {
            this.lookBackAvailablePeriods = lookBackAvailablePeriods;
        }

        @Override
        @Transient
        public final Builder lookBackAvailablePeriods(Integer lookBackAvailablePeriods) {
            this.lookBackAvailablePeriods = lookBackAvailablePeriods;
            return this;
        }

        public HistoricalOptions build() {
            return new HistoricalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoricalOptions> {
        public Builder budgetAdjustmentPeriod(Integer var1);

        public Builder lookBackAvailablePeriods(Integer var1);
    }
}

