/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComparisonOperator {
    GREATER_THAN("GREATER_THAN"),
    LESS_THAN("LESS_THAN"),
    EQUAL_TO("EQUAL_TO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComparisonOperator> VALUE_MAP;
    private final String value;

    private ComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonOperator> knownValues() {
        EnumSet<ComparisonOperator> knownValues = EnumSet.allOf(ComparisonOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComparisonOperator.class, ComparisonOperator::toString);
    }
}

