/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.ExecutionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteBudgetActionRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, ExecuteBudgetActionRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ExecuteBudgetActionRequest.getter(ExecuteBudgetActionRequest::accountId)).setter(ExecuteBudgetActionRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(ExecuteBudgetActionRequest.getter(ExecuteBudgetActionRequest::budgetName)).setter(ExecuteBudgetActionRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionId").getter(ExecuteBudgetActionRequest.getter(ExecuteBudgetActionRequest::actionId)).setter(ExecuteBudgetActionRequest.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionType").getter(ExecuteBudgetActionRequest.getter(ExecuteBudgetActionRequest::executionTypeAsString)).setter(ExecuteBudgetActionRequest.setter(Builder::executionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, ACTION_ID_FIELD, EXECUTION_TYPE_FIELD));
    private final String accountId;
    private final String budgetName;
    private final String actionId;
    private final String executionType;

    private ExecuteBudgetActionRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.actionId = builder.actionId;
        this.executionType = builder.executionType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final ExecutionType executionType() {
        return ExecutionType.fromValue(this.executionType);
    }

    public final String executionTypeAsString() {
        return this.executionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteBudgetActionRequest)) {
            return false;
        }
        ExecuteBudgetActionRequest other = (ExecuteBudgetActionRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.executionTypeAsString(), other.executionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteBudgetActionRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("ActionId", (Object)this.actionId()).add("ExecutionType", (Object)this.executionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ExecutionType": {
                return Optional.ofNullable(clazz.cast(this.executionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteBudgetActionRequest, T> g) {
        return obj -> g.apply((ExecuteBudgetActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private String actionId;
        private String executionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteBudgetActionRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.actionId(model.actionId);
            this.executionType(model.executionType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getExecutionType() {
            return this.executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        @Override
        public final Builder executionType(ExecutionType executionType) {
            this.executionType(executionType == null ? null : executionType.toString());
            return this;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteBudgetActionRequest build() {
            return new ExecuteBudgetActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteBudgetActionRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder actionId(String var1);

        public Builder executionType(String var1);

        public Builder executionType(ExecutionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

