/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.GroupsCopier;
import software.amazon.awssdk.services.budgets.model.RolesCopier;
import software.amazon.awssdk.services.budgets.model.UsersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamActionDefinition> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(IamActionDefinition.getter(IamActionDefinition::policyArn)).setter(IamActionDefinition.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<List<String>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Roles").getter(IamActionDefinition.getter(IamActionDefinition::roles)).setter(IamActionDefinition.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(IamActionDefinition.getter(IamActionDefinition::groups)).setter(IamActionDefinition.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(IamActionDefinition.getter(IamActionDefinition::users)).setter(IamActionDefinition.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, ROLES_FIELD, GROUPS_FIELD, USERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyArn;
    private final List<String> roles;
    private final List<String> groups;
    private final List<String> users;

    private IamActionDefinition(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.roles = builder.roles;
        this.groups = builder.groups;
        this.users = builder.users;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public List<String> roles() {
        return this.roles;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<String> groups() {
        return this.groups;
    }

    public boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public List<String> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamActionDefinition)) {
            return false;
        }
        IamActionDefinition other = (IamActionDefinition)obj;
        return Objects.equals(this.policyArn(), other.policyArn()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"IamActionDefinition").add("PolicyArn", (Object)this.policyArn()).add("Roles", this.hasRoles() ? this.roles() : null).add("Groups", this.hasGroups() ? this.groups() : null).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "Roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IamActionDefinition, T> g) {
        return obj -> g.apply((IamActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyArn;
        private List<String> roles = DefaultSdkAutoConstructList.getInstance();
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private List<String> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IamActionDefinition model) {
            this.policyArn(model.policyArn);
            this.roles(model.roles);
            this.groups(model.groups);
            this.users(model.users);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final Collection<String> getRoles() {
            if (this.roles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roles;
        }

        @Override
        public final Builder roles(Collection<String> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(String ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        public final void setRoles(Collection<String> roles) {
            this.roles = RolesCopier.copy(roles);
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
        }

        public final Collection<String> getUsers() {
            if (this.users instanceof SdkAutoConstructList) {
                return null;
            }
            return this.users;
        }

        @Override
        public final Builder users(Collection<String> users) {
            this.users = UsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(String ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<String> users) {
            this.users = UsersCopier.copy(users);
        }

        public IamActionDefinition build() {
            return new IamActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamActionDefinition> {
        public Builder policyArn(String var1);

        public Builder roles(Collection<String> var1);

        public Builder roles(String ... var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder users(Collection<String> var1);

        public Builder users(String ... var1);
    }
}

