/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.BudgetsCopier;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBudgetsResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, DescribeBudgetsResponse> {
    private static final SdkField<List<Budget>> BUDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Budgets").getter(DescribeBudgetsResponse.getter(DescribeBudgetsResponse::budgets)).setter(DescribeBudgetsResponse.setter(Builder::budgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Budget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBudgetsResponse.getter(DescribeBudgetsResponse::nextToken)).setter(DescribeBudgetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Budget> budgets;
    private final String nextToken;

    private DescribeBudgetsResponse(BuilderImpl builder) {
        super(builder);
        this.budgets = builder.budgets;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBudgets() {
        return this.budgets != null && !(this.budgets instanceof SdkAutoConstructList);
    }

    public List<Budget> budgets() {
        return this.budgets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgets() ? this.budgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetsResponse)) {
            return false;
        }
        DescribeBudgetsResponse other = (DescribeBudgetsResponse)((Object)obj);
        return this.hasBudgets() == other.hasBudgets() && Objects.equals(this.budgets(), other.budgets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBudgetsResponse").add("Budgets", this.hasBudgets() ? this.budgets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Budgets": {
                return Optional.ofNullable(clazz.cast(this.budgets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetsResponse, T> g) {
        return obj -> g.apply((DescribeBudgetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private List<Budget> budgets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetsResponse model) {
            super(model);
            this.budgets(model.budgets);
            this.nextToken(model.nextToken);
        }

        public final Collection<Budget.Builder> getBudgets() {
            if (this.budgets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.budgets != null ? (Collection)this.budgets.stream().map(Budget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Budget ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<Budget.Builder> ... budgets) {
            this.budgets(Stream.of(budgets).map(c -> (Budget)((Budget.Builder)Budget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBudgets(Collection<Budget.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetsResponse build() {
            return new DescribeBudgetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBudgetsResponse> {
        public Builder budgets(Collection<Budget> var1);

        public Builder budgets(Budget ... var1);

        public Builder budgets(Consumer<Budget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

