/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimePeriod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimePeriod> {
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Start").getter(TimePeriod.getter(TimePeriod::start)).setter(TimePeriod.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()}).build();
    private static final SdkField<Instant> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("End").getter(TimePeriod.getter(TimePeriod::end)).setter(TimePeriod.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant start;
    private final Instant end;

    private TimePeriod(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod)obj;
        return Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end());
    }

    public String toString() {
        return ToString.builder((String)"TimePeriod").add("Start", (Object)this.start()).add("End", (Object)this.end()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimePeriod, T> g) {
        return obj -> g.apply((TimePeriod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant start;
        private Instant end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimePeriod model) {
            this.start(model.start);
            this.end(model.end);
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public TimePeriod build() {
            return new TimePeriod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimePeriod> {
        public Builder start(Instant var1);

        public Builder end(Instant var1);
    }
}

