/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.ComparisonOperator;
import software.amazon.awssdk.services.budgets.model.NotificationState;
import software.amazon.awssdk.services.budgets.model.NotificationType;
import software.amazon.awssdk.services.budgets.model.ThresholdType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Notification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Notification> {
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Notification.getter(Notification::notificationTypeAsString)).setter(Notification.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Notification.getter(Notification::comparisonOperatorAsString)).setter(Notification.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Notification.getter(Notification::threshold)).setter(Notification.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> THRESHOLD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Notification.getter(Notification::thresholdTypeAsString)).setter(Notification.setter(Builder::thresholdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdType").build()}).build();
    private static final SdkField<String> NOTIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Notification.getter(Notification::notificationStateAsString)).setter(Notification.setter(Builder::notificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_TYPE_FIELD, COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD, THRESHOLD_TYPE_FIELD, NOTIFICATION_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String notificationType;
    private final String comparisonOperator;
    private final Double threshold;
    private final String thresholdType;
    private final String notificationState;

    private Notification(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.thresholdType = builder.thresholdType;
        this.notificationState = builder.notificationState;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeAsString() {
        return this.notificationType;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ThresholdType thresholdType() {
        return ThresholdType.fromValue(this.thresholdType);
    }

    public String thresholdTypeAsString() {
        return this.thresholdType;
    }

    public NotificationState notificationState() {
        return NotificationState.fromValue(this.notificationState);
    }

    public String notificationStateAsString() {
        return this.notificationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.thresholdTypeAsString(), other.thresholdTypeAsString()) && Objects.equals(this.notificationStateAsString(), other.notificationStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"Notification").add("NotificationType", (Object)this.notificationTypeAsString()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Threshold", (Object)this.threshold()).add("ThresholdType", (Object)this.thresholdTypeAsString()).add("NotificationState", (Object)this.notificationStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ThresholdType": {
                return Optional.ofNullable(clazz.cast(this.thresholdTypeAsString()));
            }
            case "NotificationState": {
                return Optional.ofNullable(clazz.cast(this.notificationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Notification, T> g) {
        return obj -> g.apply((Notification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notificationType;
        private String comparisonOperator;
        private Double threshold;
        private String thresholdType;
        private String notificationState;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.notificationType(model.notificationType);
            this.comparisonOperator(model.comparisonOperator);
            this.threshold(model.threshold);
            this.thresholdType(model.thresholdType);
            this.notificationState(model.notificationState);
        }

        public final String getNotificationTypeAsString() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getComparisonOperatorAsString() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getThresholdTypeAsString() {
            return this.thresholdType;
        }

        @Override
        public final Builder thresholdType(String thresholdType) {
            this.thresholdType = thresholdType;
            return this;
        }

        @Override
        public final Builder thresholdType(ThresholdType thresholdType) {
            this.thresholdType(thresholdType == null ? null : thresholdType.toString());
            return this;
        }

        public final void setThresholdType(String thresholdType) {
            this.thresholdType = thresholdType;
        }

        public final String getNotificationStateAsString() {
            return this.notificationState;
        }

        @Override
        public final Builder notificationState(String notificationState) {
            this.notificationState = notificationState;
            return this;
        }

        @Override
        public final Builder notificationState(NotificationState notificationState) {
            this.notificationState(notificationState == null ? null : notificationState.toString());
            return this;
        }

        public final void setNotificationState(String notificationState) {
            this.notificationState = notificationState;
        }

        public Notification build() {
            return new Notification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Notification> {
        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder threshold(Double var1);

        public Builder thresholdType(String var1);

        public Builder thresholdType(ThresholdType var1);

        public Builder notificationState(String var1);

        public Builder notificationState(NotificationState var1);
    }
}

