/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteBudgetRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();
    private static final DeleteBudgetRequestModelMarshaller INSTANCE = new DeleteBudgetRequestModelMarshaller();

    private DeleteBudgetRequestModelMarshaller() {
    }

    public static DeleteBudgetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteBudgetRequest deleteBudgetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteBudgetRequest), (String)"deleteBudgetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteBudgetRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)deleteBudgetRequest.budgetName(), BUDGETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

