/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Subscriber;

@SdkInternalApi
public class SubscriberMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionType").build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final SubscriberMarshaller INSTANCE = new SubscriberMarshaller();

    public static SubscriberMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscriber subscriber, ProtocolMarshaller protocolMarshaller) {
        if (subscriber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subscriber.subscriptionTypeString(), SUBSCRIPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)subscriber.address(), ADDRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

