/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.SpendMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Spend
implements StructuredPojo,
ToCopyableBuilder<Builder, Spend> {
    private final BigDecimal amount;
    private final String unit;

    private Spend(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    public BigDecimal amount() {
        return this.amount;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spend)) {
            return false;
        }
        Spend other = (Spend)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.unit(), other.unit());
    }

    public String toString() {
        return ToString.builder((String)"Spend").add("Amount", (Object)this.amount()).add("Unit", (Object)this.unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.of(clazz.cast(this.amount()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BigDecimal amount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Spend model) {
            this.amount(model.amount);
            this.unit(model.unit);
        }

        public final BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public Spend build() {
            return new Spend(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Spend> {
        public Builder amount(BigDecimal var1);

        public Builder unit(String var1);
    }
}

