/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSubscriberRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateSubscriberRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification notification;
    private final Subscriber oldSubscriber;
    private final Subscriber newSubscriber;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.oldSubscriber = builder.oldSubscriber;
        this.newSubscriber = builder.newSubscriber;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public Subscriber oldSubscriber() {
        return this.oldSubscriber;
    }

    public Subscriber newSubscriber() {
        return this.newSubscriber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.budgetName() == null ? 0 : this.budgetName().hashCode());
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        hashCode = 31 * hashCode + (this.oldSubscriber() == null ? 0 : this.oldSubscriber().hashCode());
        hashCode = 31 * hashCode + (this.newSubscriber() == null ? 0 : this.newSubscriber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.oldSubscriber() == null ^ this.oldSubscriber() == null) {
            return false;
        }
        if (other.oldSubscriber() != null && !other.oldSubscriber().equals(this.oldSubscriber())) {
            return false;
        }
        if (other.newSubscriber() == null ^ this.newSubscriber() == null) {
            return false;
        }
        return other.newSubscriber() == null || other.newSubscriber().equals(this.newSubscriber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.oldSubscriber() != null) {
            sb.append("OldSubscriber: ").append(this.oldSubscriber()).append(",");
        }
        if (this.newSubscriber() != null) {
            sb.append("NewSubscriber: ").append(this.newSubscriber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;
        private Subscriber oldSubscriber;
        private Subscriber newSubscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            this.setAccountId(model.accountId);
            this.setBudgetName(model.budgetName);
            this.setNotification(model.notification);
            this.setOldSubscriber(model.oldSubscriber);
            this.setNewSubscriber(model.newSubscriber);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getNotification() {
            return this.notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final Subscriber getOldSubscriber() {
            return this.oldSubscriber;
        }

        @Override
        public final Builder oldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
            return this;
        }

        public final void setOldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
        }

        public final Subscriber getNewSubscriber() {
            return this.newSubscriber;
        }

        @Override
        public final Builder newSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
            return this;
        }

        public final void setNewSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
        }

        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateSubscriberRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);

        public Builder oldSubscriber(Subscriber var1);

        public Builder newSubscriber(Subscriber var1);
    }
}

