/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.SubscriptionType;
import software.amazon.awssdk.services.budgets.transform.SubscriberMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscriber
implements StructuredPojo,
ToCopyableBuilder<Builder, Subscriber> {
    private final String subscriptionType;
    private final String address;

    private Subscriber(BuilderImpl builder) {
        this.subscriptionType = builder.subscriptionType;
        this.address = builder.address;
    }

    public String subscriptionType() {
        return this.subscriptionType;
    }

    public String address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionType() == null ? 0 : this.subscriptionType().hashCode());
        hashCode = 31 * hashCode + (this.address() == null ? 0 : this.address().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscriber)) {
            return false;
        }
        Subscriber other = (Subscriber)obj;
        if (other.subscriptionType() == null ^ this.subscriptionType() == null) {
            return false;
        }
        if (other.subscriptionType() != null && !other.subscriptionType().equals(this.subscriptionType())) {
            return false;
        }
        if (other.address() == null ^ this.address() == null) {
            return false;
        }
        return other.address() == null || other.address().equals(this.address());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptionType() != null) {
            sb.append("SubscriptionType: ").append(this.subscriptionType()).append(",");
        }
        if (this.address() != null) {
            sb.append("Address: ").append(this.address()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriberMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String subscriptionType;
        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscriber model) {
            this.setSubscriptionType(model.subscriptionType);
            this.setAddress(model.address);
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public Subscriber build() {
            return new Subscriber(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscriber> {
        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder address(String var1);
    }
}

