/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.math.BigDecimal;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.SpendMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Spend
implements StructuredPojo,
ToCopyableBuilder<Builder, Spend> {
    private final BigDecimal amount;
    private final String unit;

    private Spend(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    public BigDecimal amount() {
        return this.amount;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amount() == null ? 0 : this.amount().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spend)) {
            return false;
        }
        Spend other = (Spend)obj;
        if (other.amount() == null ^ this.amount() == null) {
            return false;
        }
        if (other.amount() != null && !other.amount().equals(this.amount())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amount() != null) {
            sb.append("Amount: ").append(this.amount()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private BigDecimal amount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Spend model) {
            this.setAmount(model.amount);
            this.setUnit(model.unit);
        }

        public final BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public Spend build() {
            return new Spend(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Spend> {
        public Builder amount(BigDecimal var1);

        public Builder unit(String var1);
    }
}

