/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.NotificationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotificationsForBudgetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
    private final List<Notification> notifications;
    private final String nextToken;

    private DescribeNotificationsForBudgetResponse(BuilderImpl builder) {
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notifications() == null ? 0 : this.notifications().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationsForBudgetResponse)) {
            return false;
        }
        DescribeNotificationsForBudgetResponse other = (DescribeNotificationsForBudgetResponse)((Object)obj);
        if (other.notifications() == null ^ this.notifications() == null) {
            return false;
        }
        if (other.notifications() != null && !other.notifications().equals(this.notifications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notifications() != null) {
            sb.append("Notifications: ").append(this.notifications()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Notification> notifications;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationsForBudgetResponse model) {
            this.setNotifications(model.notifications);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Notification> getNotifications() {
            return this.notifications;
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        public final void setNotifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNotificationsForBudgetResponse build() {
            return new DescribeNotificationsForBudgetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
        public Builder notifications(Collection<Notification> var1);

        public Builder notifications(Notification ... var1);

        public Builder nextToken(String var1);
    }
}

