/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum TimeUnit {
    MONTHLY("MONTHLY"),
    QUARTERLY("QUARTERLY"),
    ANNUALLY("ANNUALLY");

    private final String value;

    private TimeUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static TimeUnit fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(TimeUnit.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

