/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.services.budgets.model.SubscribersCopier;
import software.amazon.awssdk.services.budgets.transform.NotificationWithSubscribersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationWithSubscribers
implements StructuredPojo,
ToCopyableBuilder<Builder, NotificationWithSubscribers> {
    private final Notification notification;
    private final List<Subscriber> subscribers;

    private NotificationWithSubscribers(BuilderImpl builder) {
        this.notification = builder.notification;
        this.subscribers = builder.subscribers;
    }

    public Notification notification() {
        return this.notification;
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        hashCode = 31 * hashCode + (this.subscribers() == null ? 0 : this.subscribers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationWithSubscribers)) {
            return false;
        }
        NotificationWithSubscribers other = (NotificationWithSubscribers)obj;
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.subscribers() == null ^ this.subscribers() == null) {
            return false;
        }
        return other.subscribers() == null || other.subscribers().equals(this.subscribers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.subscribers() != null) {
            sb.append("Subscribers: ").append(this.subscribers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationWithSubscribersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Notification notification;
        private List<Subscriber> subscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationWithSubscribers model) {
            this.setNotification(model.notification);
            this.setSubscribers(model.subscribers);
        }

        public final Notification getNotification() {
            return this.notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final Collection<Subscriber> getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
        }

        public NotificationWithSubscribers build() {
            return new NotificationWithSubscribers(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationWithSubscribers> {
        public Builder notification(Notification var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);
    }
}

