/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteNotificationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteNotificationRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification notification;

    private DeleteNotificationRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.budgetName() == null ? 0 : this.budgetName().hashCode());
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNotificationRequest)) {
            return false;
        }
        DeleteNotificationRequest other = (DeleteNotificationRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        return other.notification() == null || other.notification().equals(this.notification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNotificationRequest model) {
            this.setAccountId(model.accountId);
            this.setBudgetName(model.budgetName);
            this.setNotification(model.notification);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getNotification() {
            return this.notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public DeleteNotificationRequest build() {
            return new DeleteNotificationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteNotificationRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);
    }
}

