/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateSubscriberRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OLDSUBSCRIBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OldSubscriber").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NEWSUBSCRIBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewSubscriber").isBinary(false).build();
    private static final UpdateSubscriberRequestModelMarshaller INSTANCE = new UpdateSubscriberRequestModelMarshaller();

    private UpdateSubscriberRequestModelMarshaller() {
    }

    public static UpdateSubscriberRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateSubscriberRequest updateSubscriberRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateSubscriberRequest), (String)"updateSubscriberRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateSubscriberRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)updateSubscriberRequest.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall((Object)updateSubscriberRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)updateSubscriberRequest.oldSubscriber(), OLDSUBSCRIBER_BINDING);
            protocolMarshaller.marshall((Object)updateSubscriberRequest.newSubscriber(), NEWSUBSCRIBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

