/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.math.BigDecimal;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SpendMarshaller {
    private static final MarshallingInfo<BigDecimal> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BIG_DECIMAL).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Amount").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").isBinary(false).build();
    private static final SpendMarshaller INSTANCE = new SpendMarshaller();

    private SpendMarshaller() {
    }

    public static SpendMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Spend spend, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)spend, (String)"spend");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)spend.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)spend.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

