/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.budgets.BudgetsClientBuilder;
import software.amazon.awssdk.services.budgets.DefaultBudgetsClientBuilder;
import software.amazon.awssdk.services.budgets.model.BudgetsException;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.CreateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.CreateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.CreationLimitExceededException;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DuplicateRecordException;
import software.amazon.awssdk.services.budgets.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.budgets.model.InternalErrorException;
import software.amazon.awssdk.services.budgets.model.InvalidNextTokenException;
import software.amazon.awssdk.services.budgets.model.InvalidParameterException;
import software.amazon.awssdk.services.budgets.model.NotFoundException;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse;

public interface BudgetsClient
extends SdkClient {
    public static final String SERVICE_NAME = "budgets";

    public static BudgetsClient create() {
        return (BudgetsClient)BudgetsClient.builder().build();
    }

    public static BudgetsClientBuilder builder() {
        return new DefaultBudgetsClientBuilder();
    }

    default public CreateBudgetResponse createBudget(CreateBudgetRequest createBudgetRequest) throws InvalidParameterException, InternalErrorException, CreationLimitExceededException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public CreateBudgetResponse createBudget(Consumer<CreateBudgetRequest.Builder> createBudgetRequest) throws InvalidParameterException, InternalErrorException, CreationLimitExceededException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        return this.createBudget((CreateBudgetRequest)((Object)((CreateBudgetRequest.Builder)CreateBudgetRequest.builder().applyMutation(createBudgetRequest)).build()));
    }

    default public CreateNotificationResponse createNotification(CreateNotificationRequest createNotificationRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, CreationLimitExceededException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public CreateNotificationResponse createNotification(Consumer<CreateNotificationRequest.Builder> createNotificationRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, CreationLimitExceededException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        return this.createNotification((CreateNotificationRequest)((Object)((CreateNotificationRequest.Builder)CreateNotificationRequest.builder().applyMutation(createNotificationRequest)).build()));
    }

    default public CreateSubscriberResponse createSubscriber(CreateSubscriberRequest createSubscriberRequest) throws InternalErrorException, InvalidParameterException, CreationLimitExceededException, DuplicateRecordException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public CreateSubscriberResponse createSubscriber(Consumer<CreateSubscriberRequest.Builder> createSubscriberRequest) throws InternalErrorException, InvalidParameterException, CreationLimitExceededException, DuplicateRecordException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.createSubscriber((CreateSubscriberRequest)((Object)((CreateSubscriberRequest.Builder)CreateSubscriberRequest.builder().applyMutation(createSubscriberRequest)).build()));
    }

    default public DeleteBudgetResponse deleteBudget(DeleteBudgetRequest deleteBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteBudgetResponse deleteBudget(Consumer<DeleteBudgetRequest.Builder> deleteBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.deleteBudget((DeleteBudgetRequest)((Object)((DeleteBudgetRequest.Builder)DeleteBudgetRequest.builder().applyMutation(deleteBudgetRequest)).build()));
    }

    default public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest deleteNotificationRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteNotificationResponse deleteNotification(Consumer<DeleteNotificationRequest.Builder> deleteNotificationRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.deleteNotification((DeleteNotificationRequest)((Object)((DeleteNotificationRequest.Builder)DeleteNotificationRequest.builder().applyMutation(deleteNotificationRequest)).build()));
    }

    default public DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSubscriberResponse deleteSubscriber(Consumer<DeleteSubscriberRequest.Builder> deleteSubscriberRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.deleteSubscriber((DeleteSubscriberRequest)((Object)((DeleteSubscriberRequest.Builder)DeleteSubscriberRequest.builder().applyMutation(deleteSubscriberRequest)).build()));
    }

    default public DescribeBudgetResponse describeBudget(DescribeBudgetRequest describeBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeBudgetResponse describeBudget(Consumer<DescribeBudgetRequest.Builder> describeBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.describeBudget((DescribeBudgetRequest)((Object)((DescribeBudgetRequest.Builder)DescribeBudgetRequest.builder().applyMutation(describeBudgetRequest)).build()));
    }

    default public DescribeBudgetsResponse describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeBudgetsResponse describeBudgets(Consumer<DescribeBudgetsRequest.Builder> describeBudgetsRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        return this.describeBudgets((DescribeBudgetsRequest)((Object)((DescribeBudgetsRequest.Builder)DescribeBudgetsRequest.builder().applyMutation(describeBudgetsRequest)).build()));
    }

    default public DescribeNotificationsForBudgetResponse describeNotificationsForBudget(DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeNotificationsForBudgetResponse describeNotificationsForBudget(Consumer<DescribeNotificationsForBudgetRequest.Builder> describeNotificationsForBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        return this.describeNotificationsForBudget((DescribeNotificationsForBudgetRequest)((Object)((DescribeNotificationsForBudgetRequest.Builder)DescribeNotificationsForBudgetRequest.builder().applyMutation(describeNotificationsForBudgetRequest)).build()));
    }

    default public DescribeSubscribersForNotificationResponse describeSubscribersForNotification(DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) throws InternalErrorException, NotFoundException, InvalidParameterException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeSubscribersForNotificationResponse describeSubscribersForNotification(Consumer<DescribeSubscribersForNotificationRequest.Builder> describeSubscribersForNotificationRequest) throws InternalErrorException, NotFoundException, InvalidParameterException, InvalidNextTokenException, ExpiredNextTokenException, AwsServiceException, SdkClientException, BudgetsException {
        return this.describeSubscribersForNotification((DescribeSubscribersForNotificationRequest)((Object)((DescribeSubscribersForNotificationRequest.Builder)DescribeSubscribersForNotificationRequest.builder().applyMutation(describeSubscribersForNotificationRequest)).build()));
    }

    default public UpdateBudgetResponse updateBudget(UpdateBudgetRequest updateBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateBudgetResponse updateBudget(Consumer<UpdateBudgetRequest.Builder> updateBudgetRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, AwsServiceException, SdkClientException, BudgetsException {
        return this.updateBudget((UpdateBudgetRequest)((Object)((UpdateBudgetRequest.Builder)UpdateBudgetRequest.builder().applyMutation(updateBudgetRequest)).build()));
    }

    default public UpdateNotificationResponse updateNotification(UpdateNotificationRequest updateNotificationRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateNotificationResponse updateNotification(Consumer<UpdateNotificationRequest.Builder> updateNotificationRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        return this.updateNotification((UpdateNotificationRequest)((Object)((UpdateNotificationRequest.Builder)UpdateNotificationRequest.builder().applyMutation(updateNotificationRequest)).build()));
    }

    default public UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateSubscriberResponse updateSubscriber(Consumer<UpdateSubscriberRequest.Builder> updateSubscriberRequest) throws InternalErrorException, InvalidParameterException, NotFoundException, DuplicateRecordException, AwsServiceException, SdkClientException, BudgetsException {
        return this.updateSubscriber((UpdateSubscriberRequest)((Object)((UpdateSubscriberRequest.Builder)UpdateSubscriberRequest.builder().applyMutation(updateSubscriberRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

