/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.DeviceQueueInfo;
import software.amazon.awssdk.services.braket.model.DeviceQueueInfoListCopier;
import software.amazon.awssdk.services.braket.model.DeviceStatus;
import software.amazon.awssdk.services.braket.model.DeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, GetDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceArn)).setter(GetDeviceResponse.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> DEVICE_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceCapabilities").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceCapabilities)).setter(GetDeviceResponse.setter(Builder::deviceCapabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapabilities").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceName").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceName)).setter(GetDeviceResponse.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()}).build();
    private static final SdkField<List<DeviceQueueInfo>> DEVICE_QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceQueueInfo").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceQueueInfo)).setter(GetDeviceResponse.setter(Builder::deviceQueueInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceQueueInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceQueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceStatus").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceStatusAsString)).setter(GetDeviceResponse.setter(Builder::deviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceStatus").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceType").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceTypeAsString)).setter(GetDeviceResponse.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(GetDeviceResponse.getter(GetDeviceResponse::providerName)).setter(GetDeviceResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD, DEVICE_CAPABILITIES_FIELD, DEVICE_NAME_FIELD, DEVICE_QUEUE_INFO_FIELD, DEVICE_STATUS_FIELD, DEVICE_TYPE_FIELD, PROVIDER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("deviceArn", DEVICE_ARN_FIELD);
            this.put("deviceCapabilities", DEVICE_CAPABILITIES_FIELD);
            this.put("deviceName", DEVICE_NAME_FIELD);
            this.put("deviceQueueInfo", DEVICE_QUEUE_INFO_FIELD);
            this.put("deviceStatus", DEVICE_STATUS_FIELD);
            this.put("deviceType", DEVICE_TYPE_FIELD);
            this.put("providerName", PROVIDER_NAME_FIELD);
        }
    });
    private final String deviceArn;
    private final String deviceCapabilities;
    private final String deviceName;
    private final List<DeviceQueueInfo> deviceQueueInfo;
    private final String deviceStatus;
    private final String deviceType;
    private final String providerName;

    private GetDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceCapabilities = builder.deviceCapabilities;
        this.deviceName = builder.deviceName;
        this.deviceQueueInfo = builder.deviceQueueInfo;
        this.deviceStatus = builder.deviceStatus;
        this.deviceType = builder.deviceType;
        this.providerName = builder.providerName;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String deviceCapabilities() {
        return this.deviceCapabilities;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final boolean hasDeviceQueueInfo() {
        return this.deviceQueueInfo != null && !(this.deviceQueueInfo instanceof SdkAutoConstructList);
    }

    public final List<DeviceQueueInfo> deviceQueueInfo() {
        return this.deviceQueueInfo;
    }

    public final DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(this.deviceStatus);
    }

    public final String deviceStatusAsString() {
        return this.deviceStatus;
    }

    public final DeviceType deviceType() {
        return DeviceType.fromValue(this.deviceType);
    }

    public final String deviceTypeAsString() {
        return this.deviceType;
    }

    public final String providerName() {
        return this.providerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceQueueInfo() ? this.deviceQueueInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse)((Object)obj);
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceCapabilities(), other.deviceCapabilities()) && Objects.equals(this.deviceName(), other.deviceName()) && this.hasDeviceQueueInfo() == other.hasDeviceQueueInfo() && Objects.equals(this.deviceQueueInfo(), other.deviceQueueInfo()) && Objects.equals(this.deviceStatusAsString(), other.deviceStatusAsString()) && Objects.equals(this.deviceTypeAsString(), other.deviceTypeAsString()) && Objects.equals(this.providerName(), other.providerName());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeviceResponse").add("DeviceArn", (Object)this.deviceArn()).add("DeviceCapabilities", (Object)this.deviceCapabilities()).add("DeviceName", (Object)this.deviceName()).add("DeviceQueueInfo", this.hasDeviceQueueInfo() ? this.deviceQueueInfo() : null).add("DeviceStatus", (Object)this.deviceStatusAsString()).add("DeviceType", (Object)this.deviceTypeAsString()).add("ProviderName", (Object)this.providerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "deviceCapabilities": {
                return Optional.ofNullable(clazz.cast(this.deviceCapabilities()));
            }
            case "deviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "deviceQueueInfo": {
                return Optional.ofNullable(clazz.cast(this.deviceQueueInfo()));
            }
            case "deviceStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusAsString()));
            }
            case "deviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeAsString()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceResponse, T> g) {
        return obj -> g.apply((GetDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceCapabilities;
        private String deviceName;
        private List<DeviceQueueInfo> deviceQueueInfo = DefaultSdkAutoConstructList.getInstance();
        private String deviceStatus;
        private String deviceType;
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            super(model);
            this.deviceArn(model.deviceArn);
            this.deviceCapabilities(model.deviceCapabilities);
            this.deviceName(model.deviceName);
            this.deviceQueueInfo(model.deviceQueueInfo);
            this.deviceStatus(model.deviceStatus);
            this.deviceType(model.deviceType);
            this.providerName(model.providerName);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceCapabilities() {
            return this.deviceCapabilities;
        }

        public final void setDeviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
        }

        @Override
        public final Builder deviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final List<DeviceQueueInfo.Builder> getDeviceQueueInfo() {
            List<DeviceQueueInfo.Builder> result = DeviceQueueInfoListCopier.copyToBuilder(this.deviceQueueInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceQueueInfo(Collection<DeviceQueueInfo.BuilderImpl> deviceQueueInfo) {
            this.deviceQueueInfo = DeviceQueueInfoListCopier.copyFromBuilder(deviceQueueInfo);
        }

        @Override
        public final Builder deviceQueueInfo(Collection<DeviceQueueInfo> deviceQueueInfo) {
            this.deviceQueueInfo = DeviceQueueInfoListCopier.copy(deviceQueueInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceQueueInfo(DeviceQueueInfo ... deviceQueueInfo) {
            this.deviceQueueInfo(Arrays.asList(deviceQueueInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceQueueInfo(Consumer<DeviceQueueInfo.Builder> ... deviceQueueInfo) {
            this.deviceQueueInfo(Stream.of(deviceQueueInfo).map(c -> (DeviceQueueInfo)((DeviceQueueInfo.Builder)DeviceQueueInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceStatus() {
            return this.deviceStatus;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceResponse> {
        public Builder deviceArn(String var1);

        public Builder deviceCapabilities(String var1);

        public Builder deviceName(String var1);

        public Builder deviceQueueInfo(Collection<DeviceQueueInfo> var1);

        public Builder deviceQueueInfo(DeviceQueueInfo ... var1);

        public Builder deviceQueueInfo(Consumer<DeviceQueueInfo.Builder> ... var1);

        public Builder deviceStatus(String var1);

        public Builder deviceStatus(DeviceStatus var1);

        public Builder deviceType(String var1);

        public Builder deviceType(DeviceType var1);

        public Builder providerName(String var1);
    }
}

